/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.actuate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.exporter.SpanReporter;

public class BufferingSpanReporter
implements SpanReporter {
    private final int capacity;
    private final AtomicInteger estimatedSize = new AtomicInteger();
    final ConcurrentLinkedQueue<FinishedSpan> spans = new ConcurrentLinkedQueue();

    public BufferingSpanReporter(int capacity) {
        this.capacity = capacity;
    }

    public List<FinishedSpan> getFinishedSpans() {
        return new ArrayList<FinishedSpan>(this.spans);
    }

    public List<FinishedSpan> drainFinishedSpans() {
        ArrayList<FinishedSpan> events = new ArrayList<FinishedSpan>();
        Iterator<FinishedSpan> iterator = this.spans.iterator();
        while (iterator.hasNext()) {
            events.add(iterator.next());
            iterator.remove();
        }
        this.estimatedSize.set(0);
        return events;
    }

    public void report(FinishedSpan span) {
        if (this.estimatedSize.get() < this.capacity) {
            this.estimatedSize.incrementAndGet();
            this.spans.add(span);
        } else {
            this.spans.poll();
            this.estimatedSize.decrementAndGet();
            this.report(span);
        }
    }
}

