/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.File;
import javax.swing.SwingUtilities;
import jep.SharedInterpreter;

public class Run {
    private static boolean interactive = false;
    private static boolean swingApp = false;
    private static String file = null;
    private static String scriptArgv = null;
    private static final String USAGE = "  Usage: jep.Run [OPTIONS]...  [FILE].. [SCRIPT ARGS]\nOptions:\n  -i                         Run script interactively.\n  -s                         Run script in event dispatching thread (for use with Swing)\n";

    public static int run(boolean bl) {
        try (SharedInterpreter sharedInterpreter = new SharedInterpreter();){
            sharedInterpreter.exec("import sys");
            sharedInterpreter.exec("sys.path.append('.')");
            if (scriptArgv.contains("\\")) {
                scriptArgv = scriptArgv.replace("\\", "\\\\");
            }
            if (scriptArgv.contains(":")) {
                scriptArgv = scriptArgv.replace(":", "\\:");
            }
            sharedInterpreter.exec("sys.argv = argv = " + scriptArgv);
            if (!file.endsWith("jep" + File.separator + "console.py")) {
                sharedInterpreter.runScript(file);
            } else {
                interactive = true;
            }
            if (interactive) {
                sharedInterpreter.set("jepInstance", sharedInterpreter);
                sharedInterpreter.exec("from jep import console");
                sharedInterpreter.exec("console.prompt(jepInstance)");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 1;
        }
        if (bl) {
            return 0;
        }
        return 0;
    }

    public static void main(String[] stringArray) throws Throwable {
        int n;
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (file != null) {
                stringArray2[n2++] = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("-i")) {
                interactive = true;
                continue;
            }
            if (stringArray[i].equals("-s")) {
                swingApp = true;
                continue;
            }
            if (stringArray[i].equals("-h")) {
                System.out.println(USAGE);
                System.exit(1);
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                System.out.println("Run: Unknown option: " + stringArray[i]);
                System.out.println(USAGE);
                System.exit(1);
                continue;
            }
            if (stringArray[i].startsWith("-")) continue;
            file = stringArray[i];
        }
        if (file == null) {
            System.out.println("Run: Invalid file, null");
            System.out.println(USAGE);
            System.exit(1);
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("'" + file + "',");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("'" + stringArray2[n] + "',");
        }
        stringBuffer.append("]");
        scriptArgv = stringBuffer.toString();
        n = 1;
        if (swingApp) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Run.run(swingApp);
                }
            });
            n = 0;
        } else {
            n = Run.run(swingApp);
        }
        if (!swingApp) {
            System.exit(n);
        }
    }

    private Run() {
    }
}

