/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.builder;

import groovy.lang.MetaProperty;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import org.spockframework.builder.CollectionSlot;
import org.spockframework.builder.ISlot;
import org.spockframework.builder.ISlotFactory;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.util.MopUtil;

public class CollectionSlotFactory
implements ISlotFactory {
    private static final Pattern pluralIESPattern = Pattern.compile(".*[^aeiouy]y", 2);

    @Override
    public ISlot create(Object owner, Type ownerType, String name) {
        String plural = this.toPluralForm(name);
        MetaProperty property = GroovyRuntimeUtil.getMetaClass(owner).getMetaProperty(plural);
        return property != null && Collection.class.isAssignableFrom(property.getType()) && MopUtil.isReadable(property) ? new CollectionSlot(plural, owner, ownerType, property) : null;
    }

    private String toPluralForm(String word) {
        if (word.toLowerCase(Locale.ROOT).endsWith("s")) {
            return word + "es";
        }
        boolean matchesIESRule = pluralIESPattern.matcher(word).matches();
        return matchesIESRule ? word.substring(0, word.length() - 1) + "ies" : word + "s";
    }
}

