/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.InteractionNotSatisfiedError;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.LinkedHashMultiset;

public class TooManyInvocationsError
extends InteractionNotSatisfiedError {
    private static final long serialVersionUID = 1L;
    private final transient IMockInteraction interaction;
    private final transient List<IMockInvocation> acceptedInvocations;
    private String message;

    public TooManyInvocationsError(IMockInteraction interaction, List<IMockInvocation> acceptedInvocations) {
        this.interaction = interaction;
        this.acceptedInvocations = acceptedInvocations;
    }

    public IMockInteraction getInteraction() {
        return this.interaction;
    }

    public List<IMockInvocation> getAcceptedInvocations() {
        return this.acceptedInvocations;
    }

    public synchronized String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        LinkedHashMultiset<IMockInvocation> uniqueInvocations = new LinkedHashMultiset<IMockInvocation>();
        for (IMockInvocation invocation : CollectionUtil.reverse(this.acceptedInvocations)) {
            uniqueInvocations.add(invocation);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Too many invocations for:\n\n");
        builder.append(this.interaction);
        builder.append("\n\n");
        builder.append("Matching invocations (ordered by last occurrence):\n\n");
        int count = 0;
        for (Map.Entry entry : uniqueInvocations.entrySet()) {
            builder.append(entry.getValue());
            builder.append(" * ");
            builder.append(entry.getKey());
            if (count++ == 0) {
                builder.append("   <-- this triggered the error");
            }
            builder.append("\n");
        }
        builder.append("\n");
        this.message = builder.toString();
        return this.message;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getMessage();
        out.defaultWriteObject();
    }
}

