/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.IStoppable;

public class AsyncRunListener
implements IRunListener,
IStoppable {
    private static final Runnable STOP = () -> {
        throw new IllegalStateException("should never run");
    };
    private final IRunListener delegate;
    private final Thread workerThread;
    private final BlockingQueue<Runnable> events = new LinkedBlockingQueue<Runnable>();
    private volatile boolean stopped = false;

    public AsyncRunListener(String threadName, IRunListener delegate) {
        this.delegate = delegate;
        this.workerThread = new Thread(threadName){

            @Override
            public void run() {
                try {
                    while (true) {
                        Runnable event;
                        if ((event = (Runnable)AsyncRunListener.this.events.take()) == STOP) {
                            return;
                        }
                        event.run();
                    }
                }
                catch (Throwable t) {
                    AsyncRunListener.this.stopped = true;
                    t.printStackTrace();
                    return;
                }
            }
        };
    }

    public void start() {
        this.workerThread.start();
    }

    @Override
    public void stop() throws InterruptedException {
        this.addEvent(STOP);
        this.workerThread.join();
    }

    @Override
    public void beforeSpec(SpecInfo spec) {
        this.addEvent(() -> this.delegate.beforeSpec(spec));
    }

    @Override
    public void beforeFeature(FeatureInfo feature) {
        this.addEvent(() -> this.delegate.beforeFeature(feature));
    }

    @Override
    public void beforeIteration(IterationInfo iteration) {
        this.addEvent(() -> this.delegate.beforeIteration(iteration));
    }

    @Override
    public void afterIteration(IterationInfo iteration) {
        this.addEvent(() -> this.delegate.afterIteration(iteration));
    }

    @Override
    public void afterFeature(FeatureInfo feature) {
        this.addEvent(() -> this.delegate.afterFeature(feature));
    }

    @Override
    public void afterSpec(SpecInfo spec) {
        this.addEvent(() -> this.delegate.afterSpec(spec));
    }

    @Override
    public void error(ErrorInfo error) {
        this.addEvent(() -> this.delegate.error(error));
    }

    @Override
    public void specSkipped(SpecInfo spec) {
        this.addEvent(() -> this.delegate.specSkipped(spec));
    }

    @Override
    public void featureSkipped(FeatureInfo feature) {
        this.addEvent(() -> this.delegate.featureSkipped(feature));
    }

    protected void addEvent(Runnable event) {
        if (this.stopped) {
            return;
        }
        this.events.add(event);
    }
}

