/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.SpecInfoBuilder;
import org.spockframework.runtime.SpecNode;
import org.spockframework.runtime.SpecUtil;
import org.spockframework.runtime.SpockException;
import org.spockframework.runtime.model.SpecInfo;
import spock.config.RunnerConfiguration;

class ClassSelectorResolver
implements SelectorResolver {
    private final Predicate<String> classNameFilter;
    private final RunContext runContext;

    ClassSelectorResolver(Predicate<String> classNameFilter, RunContext runContext) {
        this.classNameFilter = classNameFilter;
        this.runContext = runContext;
    }

    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        return this.resolveClass(selector.getJavaClass(), context);
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId.Segment lastSegment = selector.getUniqueId().getLastSegment();
        if ("spec".equals(lastSegment.getType())) {
            String className = lastSegment.getValue();
            Class specClass = (Class)ReflectionSupport.tryToLoadClass((String)className).getOrThrow(SpockException::new);
            return this.resolveClass(specClass, context);
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private SelectorResolver.Resolution resolveClass(Class<?> specClass, SelectorResolver.Context context) {
        if (SpecUtil.isRunnableSpec(specClass) && this.classNameFilter.test(specClass.getName())) {
            return context.addToParent(parent -> {
                SpecInfo specInfo = new SpecInfoBuilder(specClass).build();
                specInfo.getAllFeatures().forEach(featureInfo -> featureInfo.setExcluded(true));
                UniqueId uniqueId = parent.getUniqueId().append("spec", ((Class)specInfo.getReflection()).getName());
                return Optional.of(new SpecNode(uniqueId, this.runContext.getConfiguration(RunnerConfiguration.class), specInfo));
            }).map(this::toResolution).orElse(SelectorResolver.Resolution.unresolved());
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private SelectorResolver.Resolution toResolution(SpecNode specNode) {
        return SelectorResolver.Resolution.match((SelectorResolver.Match)SelectorResolver.Match.exact((TestDescriptor)specNode, this.features((SpecInfo)specNode.getNodeInfo())));
    }

    private Supplier<Set<? extends DiscoverySelector>> features(SpecInfo specInfo) {
        return () -> {
            specInfo.getAllFeatures().forEach(featureInfo -> featureInfo.setExcluded(false));
            return Collections.emptySet();
        };
    }
}

