/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Map;
import java.util.StringJoiner;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.NameProvider;
import org.spockframework.util.RenderUtil;

public class DataVariablesIterationNameProvider
implements NameProvider<IterationInfo> {
    private final boolean includeFeatureNameForIterations;
    private final boolean includeIterationIndex;

    public DataVariablesIterationNameProvider() {
        this(true, true);
    }

    public DataVariablesIterationNameProvider(boolean includeFeatureNameForIterations) {
        this(includeFeatureNameForIterations, true);
    }

    public DataVariablesIterationNameProvider(boolean includeFeatureNameForIterations, boolean includeIterationIndex) {
        this.includeFeatureNameForIterations = includeFeatureNameForIterations;
        this.includeIterationIndex = includeIterationIndex;
    }

    @Override
    public String getName(IterationInfo iteration) {
        FeatureInfo feature = iteration.getFeature();
        if (!feature.isReportIterations()) {
            return feature.getName();
        }
        StringJoiner nameJoiner = new StringJoiner(", ");
        Map<String, Object> dataVariables = iteration.getDataVariables();
        if (dataVariables != null) {
            dataVariables.forEach((name, value) -> {
                String valueString;
                try {
                    valueString = RenderUtil.toStringOrDump(value);
                }
                catch (Exception e) {
                    valueString = String.format("#Error:%s during rendering", e.getClass().getSimpleName());
                }
                nameJoiner.add(String.format("%s: %s", name, valueString));
            });
        }
        if (this.includeIterationIndex) {
            nameJoiner.add(String.format("#%d", iteration.getIterationIndex()));
        }
        return this.includeFeatureNameForIterations ? String.format("%s [%s]", feature.getName(), nameJoiner) : nameJoiner.toString();
    }
}

