/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.platform.engine.TestDescriptor;
import org.spockframework.runtime.DataIteratorFactory;
import org.spockframework.runtime.IDataIterator;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.IterationNode;
import org.spockframework.runtime.ParameterizedFeatureChildExecutor;
import org.spockframework.runtime.PlatformSpecRunner;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.extension.IDataDriver;
import org.spockframework.runtime.extension.IIterationRunner;
import org.spockframework.runtime.model.ExecutionResult;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.util.ExceptionUtil;
import spock.config.RunnerConfiguration;

public class PlatformParameterizedSpecRunner
extends PlatformSpecRunner {
    public PlatformParameterizedSpecRunner(IRunSupervisor supervisor) {
        super(supervisor);
    }

    @Override
    void runParameterizedFeature(SpockExecutionContext context, ParameterizedFeatureChildExecutor childExecutor) throws InterruptedException {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        FeatureInfo feature = context.getCurrentFeature();
        try (IDataIterator dataIterator = new DataIteratorFactory(this.supervisor).createFeatureDataIterator(context);){
            IIterationRunner iterationRunner = this.createIterationRunner(context, childExecutor);
            IDataDriver dataDriver = feature.getDataDriver();
            dataDriver.runIterations(dataIterator, iterationRunner, feature.getFeatureMethod().getParameters());
            childExecutor.awaitFinished();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            ExceptionUtil.sneakyThrow(e);
        }
    }

    private IIterationRunner createIterationRunner(final SpockExecutionContext context, final ParameterizedFeatureChildExecutor childExecutor) {
        return new IIterationRunner(){
            private final AtomicInteger iterationIndex = new AtomicInteger(0);

            @Override
            public CompletableFuture<ExecutionResult> runIteration(Object[] args) {
                int currIterationIndex = this.iterationIndex.getAndIncrement();
                IterationInfo iterationInfo = PlatformParameterizedSpecRunner.this.createIterationInfo(context, currIterationIndex, args, -1);
                IterationNode iterationNode = new IterationNode(context.getParentId().append("iteration", String.valueOf(currIterationIndex)), context.getRunContext().getConfiguration(RunnerConfiguration.class), iterationInfo);
                if (context.getErrorInfoCollector().hasErrors()) {
                    return CompletableFuture.completedFuture(ExecutionResult.REJECTED);
                }
                if (iterationInfo.getFeature().getIterationFilter().isAllowed(iterationInfo.getIterationIndex())) {
                    return childExecutor.execute((TestDescriptor)iterationNode);
                }
                return CompletableFuture.completedFuture(ExecutionResult.SKIPPED);
            }
        };
    }
}

