/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.NameProvider;

public class SafeIterationNameProvider
implements NameProvider<IterationInfo> {
    private final NameProvider<IterationInfo> delegate;

    public SafeIterationNameProvider(NameProvider<IterationInfo> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getName(IterationInfo iteration) {
        if (this.delegate == null) {
            return this.getFallbackName(iteration);
        }
        try {
            String name = this.delegate.getName(iteration);
            if (name != null) {
                return name;
            }
            return this.getFallbackName(iteration);
        }
        catch (Exception e) {
            return this.getFallbackName(iteration);
        }
    }

    private String getFallbackName(IterationInfo iteration) {
        return iteration.getFeature().isReportIterations() ? String.format("%s [#%d]", iteration.getFeature().getName(), iteration.getIterationIndex()) : iteration.getFeature().getName();
    }
}

