/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spockframework.runtime.IMethodNameMapper;
import org.spockframework.runtime.IStackTraceFilter;
import org.spockframework.util.InternalIdentifiers;

public class StackTraceFilter
implements IStackTraceFilter {
    private static final Pattern FILTERED_CLASSES = Pattern.compile("\\Qorg.codehaus.groovy.runtime.\\E.*|\\Qorg.codehaus.groovy.reflection.\\E.*|\\Qorg.codehaus.groovy.\\E.*MetaClass.*|\\Qorg.codehaus.groovy.vmplugin.v8.\\E.*|groovy\\..*MetaClass.*|groovy\\.lang\\.MetaMethod|\\Qjava.lang.reflect.\\E.*|sun\\.reflect\\..*|\\Qjdk.internal.reflect.\\E.*|\\Qorg.spockframework.runtime.\\E[^.]+");
    private static final Pattern CLOSURE_CLASS = Pattern.compile("(.+)\\$_(.+)_closure(\\d+)");
    private static final StackTraceElement[] STACK_TRACE_ELEMENTS = new StackTraceElement[0];
    private final IMethodNameMapper mapper;

    public StackTraceFilter(IMethodNameMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void filter(Throwable throwable) {
        ArrayList<StackTraceElement> filteredTrace = new ArrayList<StackTraceElement>();
        for (StackTraceElement elem : throwable.getStackTrace()) {
            if (this.isInitializerOrFixtureMethod(elem)) {
                filteredTrace.add(elem);
                break;
            }
            if (this.checkForAndAddPrettyPrintedFeatureMethod(elem, filteredTrace)) break;
            if (StackTraceFilter.isFilteredClass(elem) || this.checkForAndAddPrettyPrintedClosureInvocation(elem, filteredTrace) || this.isGeneratedMethod(elem)) continue;
            filteredTrace.add(elem);
        }
        throwable.setStackTrace(filteredTrace.toArray(STACK_TRACE_ELEMENTS));
        if (throwable.getCause() != null) {
            this.filter(throwable.getCause());
        }
    }

    private boolean isInitializerOrFixtureMethod(StackTraceElement elem) {
        return this.mapper.isInitializerOrFixtureMethod(elem.getClassName(), elem.getMethodName());
    }

    private static boolean isFilteredClass(StackTraceElement elem) {
        return FILTERED_CLASSES.matcher(elem.getClassName()).matches();
    }

    private boolean checkForAndAddPrettyPrintedFeatureMethod(StackTraceElement elem, List<StackTraceElement> trace) {
        if (!InternalIdentifiers.isFeatureMethodName(elem.getMethodName())) {
            return false;
        }
        trace.add(this.prettyPrintFeatureMethod(elem));
        return true;
    }

    private StackTraceElement prettyPrintFeatureMethod(StackTraceElement elem) {
        return new StackTraceElement(elem.getClassName(), this.mapper.toFeatureName(elem.getMethodName()), elem.getFileName(), elem.getLineNumber());
    }

    private boolean checkForAndAddPrettyPrintedClosureInvocation(StackTraceElement elem, List<StackTraceElement> trace) {
        if (!"doCall".equals(elem.getMethodName())) {
            return false;
        }
        Matcher matcher = CLOSURE_CLASS.matcher(elem.getClassName());
        if (!matcher.matches()) {
            return false;
        }
        trace.add(this.prettyPrintClosureInvocation(elem, matcher));
        return true;
    }

    private StackTraceElement prettyPrintClosureInvocation(StackTraceElement elem, Matcher matcher) {
        String classContainingClosureDef = matcher.group(1);
        String methodContainingClosureDef = matcher.group(2);
        String consecutiveNumberOfClosureDef = matcher.group(3);
        String unmangledName = "$" + methodContainingClosureDef.substring(1);
        if (InternalIdentifiers.isInternalName(unmangledName)) {
            methodContainingClosureDef = unmangledName;
        }
        String prettyClassName = classContainingClosureDef;
        String prettyMethodName = this.mapper.toFeatureName(methodContainingClosureDef) + "_closure" + consecutiveNumberOfClosureDef;
        return new StackTraceElement(prettyClassName, prettyMethodName, elem.getFileName(), elem.getLineNumber());
    }

    private boolean isGeneratedMethod(StackTraceElement elem) {
        return elem.getLineNumber() < 0;
    }
}

