/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.util.ArrayList;
import java.util.Collection;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;

public class ConfineMetaClassChangesInterceptor
implements IMethodInterceptor {
    private final Collection<Class<?>> classes;

    public ConfineMetaClassChangesInterceptor(Collection<Class<?>> classes) {
        this.classes = classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        ArrayList<MetaClass> originalMetaClasses = new ArrayList<MetaClass>();
        for (Class<?> clazz : this.classes) {
            originalMetaClasses.add(registry.getMetaClass(clazz));
            ExpandoMetaClass temporaryMetaClass = new ExpandoMetaClass(clazz, true, true);
            temporaryMetaClass.initialize();
            registry.setMetaClass(clazz, (MetaClass)temporaryMetaClass);
        }
        try {
            invocation.proceed();
        }
        finally {
            for (MetaClass original : originalMetaClasses) {
                registry.setMetaClass(original.getTheClass(), original);
            }
        }
    }
}

