/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import java.util.ArrayList;
import org.opentest4j.MultipleFailuresError;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.RetryConditionContext;
import spock.lang.Retry;

public class RetryBaseInterceptor {
    protected final Retry retry;
    protected final Closure condition;

    public RetryBaseInterceptor(Retry retry) {
        this(retry, RetryBaseInterceptor.createCondition(retry.condition()));
    }

    protected RetryBaseInterceptor(Retry retry, Closure condition) {
        this.retry = retry;
        this.condition = condition;
    }

    private static Closure createCondition(Class<? extends Closure> clazz) {
        if (clazz.equals(Closure.class)) {
            return null;
        }
        try {
            return clazz.getConstructor(Object.class, Object.class).newInstance(null, null);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate @Retry condition", e);
        }
    }

    protected boolean isExpected(IMethodInvocation invocation, Throwable failure) {
        return this.hasExpectedClass(failure) && this.satisfiesCondition(invocation, failure);
    }

    private boolean hasExpectedClass(Throwable failure) {
        for (Class<? extends Throwable> exception : this.retry.exceptions()) {
            if (!exception.isInstance(failure)) continue;
            return true;
        }
        return false;
    }

    private boolean satisfiesCondition(IMethodInvocation invocation, Throwable failure) {
        if (this.condition == null) {
            return true;
        }
        Closure condition = this.condition.rehydrate((Object)new RetryConditionContext(invocation.getInstance(), failure), invocation.getSpec().getReflection(), null);
        condition.setResolveStrategy(1);
        try {
            return GroovyRuntimeUtil.isTruthy(condition.call());
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to evaluate @Retry condition", e);
        }
    }

    protected void handleInvocation(IMethodInvocation invocation) throws Throwable {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>(this.retry.count() + 1);
        for (int i = 0; i <= this.retry.count(); ++i) {
            try {
                invocation.proceed();
                return;
            }
            catch (Throwable e) {
                if (this.isExpected(invocation, e)) {
                    throwables.add(e);
                    if (this.retry.delay() <= 0) continue;
                    Thread.sleep(this.retry.delay());
                    continue;
                }
                throw e;
            }
        }
        throw new MultipleFailuresError("Retries exhausted", throwables);
    }
}

