/*
 * Decompiled with CFR 0.152.
 */
package spock.config;

import java.math.BigDecimal;
import org.spockframework.runtime.DefaultParallelExecutionConfiguration;
import org.spockframework.runtime.model.parallel.ExecutionMode;

public class ParallelConfiguration {
    private static final int KEEP_ALIVE_SECONDS = 30;
    private static final int MAX_POOL_SIZE_BASE = 256;
    public boolean enabled = Boolean.getBoolean("spock.parallel.enabled");
    public ExecutionMode defaultSpecificationExecutionMode = ExecutionMode.CONCURRENT;
    public ExecutionMode defaultExecutionMode = ExecutionMode.CONCURRENT;
    private DefaultParallelExecutionConfiguration parallelExecutionConfiguration;

    public ParallelConfiguration() {
        this.dynamicWithReservedProcessors(BigDecimal.ONE, 2);
    }

    public void dynamic(BigDecimal factor) {
        int parallelism = Math.max(1, factor.multiply(BigDecimal.valueOf(Runtime.getRuntime().availableProcessors())).intValue());
        this.fixed(parallelism);
    }

    public void dynamicWithReservedProcessors(BigDecimal factor, int reservedProcessors) {
        if (factor.compareTo(BigDecimal.ONE) > 0 && reservedProcessors > 0) {
            throw new IllegalArgumentException("A factor larger than 1 with reserved threads is unsupported.");
        }
        if (reservedProcessors < 0) {
            throw new IllegalArgumentException("A negative value for reservedProcessors is illegal.");
        }
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int wantedParallelism = Math.min(factor.multiply(BigDecimal.valueOf(availableProcessors)).intValue(), availableProcessors - reservedProcessors);
        int parallelism = Math.max(1, wantedParallelism);
        this.fixed(parallelism);
    }

    public void fixed(int parallelism) {
        this.custom(parallelism, parallelism, 256 + parallelism, parallelism, 30);
    }

    public void custom(int parallelism, int minimumRunnable, int maxPoolSize, int corePoolSize, int keepAliveSeconds) {
        this.parallelExecutionConfiguration = new DefaultParallelExecutionConfiguration(parallelism, minimumRunnable, maxPoolSize, corePoolSize, keepAliveSeconds);
    }

    public DefaultParallelExecutionConfiguration getParallelExecutionConfiguration() {
        return this.parallelExecutionConfiguration;
    }
}

