/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration.security.jwt;

import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.filter.CommonsRequestLoggingFilter;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtAuthFacade;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtTokenFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@ConditionalOnProperty(name={"higson.runtime-rest.security.type"}, havingValue="jwt")
public class JwtWebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private final JwtAuthFacade facade;

    public void configure(WebSecurity web) {
        web.ignoring().antMatchers(new String[]{"/actuator/**", "/swagger-ui.html", "/swagger-ui/**", "/api/v3/api-docs/*"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).authorizeRequests().anyRequest()).authenticated().and()).addFilterBefore((Filter)new JwtTokenFilter(this.facade), UsernamePasswordAuthenticationFilter.class).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    @Bean
    public CommonsRequestLoggingFilter requestLoggingFilter() {
        CommonsRequestLoggingFilter loggingFilter = new CommonsRequestLoggingFilter();
        loggingFilter.setIncludeClientInfo(true);
        loggingFilter.setIncludeQueryString(true);
        loggingFilter.setIncludePayload(true);
        loggingFilter.setIncludeHeaders(true);
        return loggingFilter;
    }

    public JwtWebSecurityConfig(JwtAuthFacade facade) {
        this.facade = facade;
    }
}

