/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution.api.validator;

import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.rest.execution.api.dto.ContextProperty;
import pl.decerto.hyperon.rest.execution.api.dto.EffectiveVersionConfigurationDto;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionContext;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionData;
import pl.decerto.hyperon.rest.execution.api.dto.ExecutionElementIdentifier;
import pl.decerto.hyperon.rest.execution.api.dto.RegionVersionIdentifierDto;
import pl.decerto.hyperon.rest.execution.api.validator.BadRequestExecption;

@Component
public class ExecutionDataValidator {
    private static final Logger log = LoggerFactory.getLogger(ExecutionDataValidator.class);

    public void validate(ExecutionData data) {
        List<ExecutionElementIdentifier> elements;
        if (data.getCtx() != null) {
            this.validate(data.getCtx());
        }
        if (data.getEffectiveVersionConfiguration() != null) {
            this.validate(data.getEffectiveVersionConfiguration());
        }
        if ((elements = data.getElements()) == null || elements.isEmpty()) {
            throw new BadRequestExecption("Empty [elements] list. At least 1 element is required.");
        }
        elements.forEach(this::validate);
    }

    private void validate(ExecutionContext ctx) {
        List<ContextProperty> properties = ctx.getProperties();
        if (properties == null) {
            throw new BadRequestExecption("ctx.properties can not be null");
        }
        MutableInt index = new MutableInt();
        for (ContextProperty prop : properties) {
            this.validateKey(prop, () -> String.format("ctx.properties[%d]", index.intValue()));
            this.validate(prop, prop::getKey);
            index.increment();
        }
    }

    private void validateKey(ContextProperty prop, Supplier<String> path) {
        if (StringUtils.isBlank((CharSequence)prop.getKey())) {
            throw new BadRequestExecption(String.format("%s.key is required", path.get()));
        }
    }

    private void validate(ContextProperty prop, Supplier<String> path) {
        if (prop.getComplexValue() != null) {
            this.validateCompoundValue(prop.getComplexValue(), path);
        }
        if (prop.getComplexValues() != null) {
            this.validateCollectionValue(prop.getComplexValues(), path);
        }
    }

    private void validateCompoundValue(List<ContextProperty> props, Supplier<String> path) {
        MutableInt index = new MutableInt();
        while (index.intValue() < props.size()) {
            ContextProperty cp = this.get(props, index);
            this.validateKey(cp, () -> String.format("%s[%s]", path.get(), index));
            this.validate(cp, () -> String.format("%s.%s", path.get(), cp.getKey()));
            index.increment();
        }
    }

    private void validateCollectionValue(List<List<ContextProperty>> coll, Supplier<String> path) {
        MutableInt i = new MutableInt();
        while (i.intValue() < coll.size()) {
            List<ContextProperty> list = this.get(coll, i);
            MutableInt j = new MutableInt();
            while (j.intValue() < list.size()) {
                ContextProperty cp = this.get(list, j);
                this.validateKey(cp, () -> String.format("%s[%s][%s]", path.get(), i, j));
                this.validate(cp, () -> String.format("%s[%s].%s", path.get(), i, cp.getKey()));
                j.increment();
            }
            i.increment();
        }
    }

    private <T> T get(List<T> list, MutableInt index) {
        return list.get(index.intValue());
    }

    private void validate(EffectiveVersionConfigurationDto conf) {
        if (conf.getRegionVersionIdentifier() != null) {
            for (RegionVersionIdentifierDto rv : conf.getRegionVersionIdentifier()) {
                this.validate(rv);
            }
        }
    }

    private void validate(RegionVersionIdentifierDto rv) {
        if (StringUtils.isBlank((CharSequence)rv.getVersion())) {
            throw new BadRequestExecption("[regionVersionIdentifier.version] is required");
        }
        if (rv.getRegionIdentifier() == null) {
            throw new BadRequestExecption("[regionVersionIdentifier.regionIdentifier] is required");
        }
        if (StringUtils.isBlank((CharSequence)rv.getRegionIdentifier().getRegionCode())) {
            throw new BadRequestExecption("[regionVersionIdentifier.regionIdentifier.regionCode] is required");
        }
    }

    private void validate(ExecutionElementIdentifier elementIdentifier) {
        if (StringUtils.isBlank((CharSequence)elementIdentifier.getCode())) {
            throw new BadRequestExecption("[elements.code] is required");
        }
        if (elementIdentifier.getType() == null) {
            throw new BadRequestExecption("[elements.type] is required");
        }
    }
}

