/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.messaging.ProducerRequest;
import brave.propagation.Propagation;
import brave.spring.rabbit.MessageHeaders;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

final class MessageProducerRequest
extends ProducerRequest {
    static final Propagation.RemoteGetter<MessageProducerRequest> GETTER = new Propagation.RemoteGetter<MessageProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public String get(MessageProducerRequest request, String name) {
            return MessageHeaders.getHeaderIfString(request.delegate, name);
        }

        public String toString() {
            return "MessageProperties::getHeader";
        }
    };
    static final Propagation.RemoteSetter<MessageProducerRequest> SETTER = new Propagation.RemoteSetter<MessageProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public void put(MessageProducerRequest request, String name, String value) {
            MessageHeaders.setHeader(request.delegate, name, value);
        }

        public String toString() {
            return "MessageProperties::setHeader";
        }
    };
    final Message delegate;

    MessageProducerRequest(Message delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public Span.Kind spanKind() {
        return Span.Kind.PRODUCER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "send";
    }

    public String channelKind() {
        return "queue";
    }

    public String channelName() {
        MessageProperties properties = this.delegate.getMessageProperties();
        return properties != null ? properties.getConsumerQueue() : null;
    }

    public String messageId() {
        MessageProperties properties = this.delegate.getMessageProperties();
        return properties != null ? properties.getMessageId() : null;
    }
}

