/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.core.config;

import com.amazonaws.regions.Regions;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.credentials.CredentialsProviderFactoryBean;
import io.awspring.cloud.core.region.StaticRegionProvider;
import java.beans.Introspector;
import java.net.URI;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class AmazonWebserviceClientConfigurationUtils {
    public static final String REGION_PROVIDER_BEAN_NAME = "io.awspring.cloud.core.region.RegionProvider.BEAN_NAME";
    public static final String GLOBAL_CLIENT_CONFIGURATION_BEAN_NAME = "com.amazonaws.ClientConfiguration.BEAN_NAME";
    public static final String CREDENTIALS_PROVIDER_BEAN_NAME = "io.awspring.cloud.core.credentials.CredentialsProviderFactoryBean.BEAN_NAME";
    private static final String SERVICE_IMPLEMENTATION_SUFFIX = "Client";

    private AmazonWebserviceClientConfigurationUtils() {
    }

    public static BeanDefinitionHolder registerAmazonWebserviceClient(Object source, BeanDefinitionRegistry registry, String serviceNameClassName, String customRegionProvider, String customRegion) {
        return AmazonWebserviceClientConfigurationUtils.registerAmazonWebserviceClient(source, registry, serviceNameClassName, customRegionProvider, customRegion, null, null);
    }

    public static BeanDefinitionHolder registerAmazonWebserviceClient(Object source, BeanDefinitionRegistry registry, String serviceNameClassName, String customRegionProvider, String customRegion, String customEndpoint, String clientConfigurationBeanName) {
        String beanName = AmazonWebserviceClientConfigurationUtils.getBeanName(serviceNameClassName);
        if (registry.containsBeanDefinition(beanName)) {
            return new BeanDefinitionHolder(registry.getBeanDefinition(beanName), beanName);
        }
        AbstractBeanDefinition definition = AmazonWebserviceClientConfigurationUtils.getAmazonWebserviceClientBeanDefinition(source, serviceNameClassName, customRegionProvider, customRegion, customEndpoint, registry, clientConfigurationBeanName);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)definition, beanName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        return holder;
    }

    public static AbstractBeanDefinition getAmazonWebserviceClientBeanDefinition(Object source, String serviceNameClassName, String customRegionProvider, String customRegion, String customEndpoint, BeanDefinitionRegistry beanDefinitionRegistry, String clientConfigurationBeanName) {
        if (StringUtils.hasText((String)customRegionProvider) && StringUtils.hasText((String)customRegion)) {
            throw new IllegalArgumentException("Only region or regionProvider can be configured, but not both");
        }
        AmazonWebserviceClientConfigurationUtils.registerCredentialsProviderIfNeeded(beanDefinitionRegistry);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(AmazonWebserviceClientFactoryBean.class);
        builder.addConstructorArgValue((Object)serviceNameClassName);
        builder.addConstructorArgReference(CREDENTIALS_PROVIDER_BEAN_NAME);
        builder.getRawBeanDefinition().setSource(source);
        if (StringUtils.hasText((String)customEndpoint)) {
            builder.addPropertyValue("customEndpoint", (Object)URI.create(customEndpoint));
        } else if (StringUtils.hasText((String)customRegionProvider)) {
            builder.addPropertyReference("regionProvider", customRegionProvider);
        } else if (StringUtils.hasText((String)customRegion)) {
            builder.addPropertyValue("customRegion", (Object)customRegion);
        } else {
            AmazonWebserviceClientConfigurationUtils.registerRegionProviderBeanIfNeeded(beanDefinitionRegistry);
            builder.addPropertyReference("regionProvider", REGION_PROVIDER_BEAN_NAME);
        }
        if (clientConfigurationBeanName != null && beanDefinitionRegistry.containsBeanDefinition(clientConfigurationBeanName)) {
            builder.addPropertyReference("clientConfiguration", clientConfigurationBeanName);
        } else if (beanDefinitionRegistry.containsBeanDefinition(GLOBAL_CLIENT_CONFIGURATION_BEAN_NAME)) {
            builder.addPropertyReference("clientConfiguration", GLOBAL_CLIENT_CONFIGURATION_BEAN_NAME);
        }
        return builder.getBeanDefinition();
    }

    public static String getBeanName(String serviceClassName) {
        String clientClassName = ClassUtils.getShortName((String)serviceClassName);
        String shortenedClassName = StringUtils.delete((String)clientClassName, (String)SERVICE_IMPLEMENTATION_SUFFIX);
        return Introspector.decapitalize(shortenedClassName);
    }

    public static String getRegionProviderBeanName(BeanDefinitionRegistry beanDefinitionRegistry) {
        AmazonWebserviceClientConfigurationUtils.registerRegionProviderBeanIfNeeded(beanDefinitionRegistry);
        return REGION_PROVIDER_BEAN_NAME;
    }

    public static void replaceDefaultRegionProvider(BeanDefinitionRegistry registry, String customGlobalRegionProvider) {
        if (registry.containsBeanDefinition(REGION_PROVIDER_BEAN_NAME)) {
            registry.removeBeanDefinition(REGION_PROVIDER_BEAN_NAME);
        }
        registry.registerAlias(customGlobalRegionProvider, REGION_PROVIDER_BEAN_NAME);
    }

    private static void registerRegionProviderBeanIfNeeded(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(REGION_PROVIDER_BEAN_NAME)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticRegionProvider.class);
            builder.addConstructorArgValue((Object)Regions.DEFAULT_REGION.getName());
            builder.setRole(2);
            registry.registerBeanDefinition(REGION_PROVIDER_BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private static void registerCredentialsProviderIfNeeded(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(CREDENTIALS_PROVIDER_BEAN_NAME)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CredentialsProviderFactoryBean.class);
            builder.setRole(2);
            registry.registerBeanDefinition(CREDENTIALS_PROVIDER_BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    public static void replaceDefaultCredentialsProvider(BeanDefinitionRegistry registry, String customGlobalCredentialsProvider) {
        if (registry.containsBeanDefinition(CREDENTIALS_PROVIDER_BEAN_NAME)) {
            registry.removeBeanDefinition(CREDENTIALS_PROVIDER_BEAN_NAME);
        }
        registry.registerAlias(customGlobalCredentialsProvider, CREDENTIALS_PROVIDER_BEAN_NAME);
    }
}

