/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.core.env.stack.config;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.StackResource;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.TagDescription;
import io.awspring.cloud.core.env.ec2.AmazonEc2InstanceIdProvider;
import io.awspring.cloud.core.env.ec2.InstanceIdProvider;
import io.awspring.cloud.core.env.stack.config.StackNameProvider;
import java.util.Collections;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AutoDetectingStackNameProvider
implements StackNameProvider,
InitializingBean {
    private final AmazonCloudFormation amazonCloudFormationClient;
    private final AmazonEC2 amazonEc2Client;
    private final InstanceIdProvider instanceIdProvider;
    private String stackName;

    private AutoDetectingStackNameProvider(AmazonCloudFormation amazonCloudFormationClient, AmazonEC2 amazonEc2Client, InstanceIdProvider instanceIdProvider) {
        this.amazonCloudFormationClient = amazonCloudFormationClient;
        this.amazonEc2Client = amazonEc2Client;
        this.instanceIdProvider = instanceIdProvider;
        this.afterPropertiesSet();
    }

    public AutoDetectingStackNameProvider(AmazonCloudFormation amazonCloudFormationClient, AmazonEC2 amazonEc2Client) {
        this(amazonCloudFormationClient, amazonEc2Client, new AmazonEc2InstanceIdProvider());
    }

    public void afterPropertiesSet() {
        String instanceId = this.instanceIdProvider.getCurrentInstanceId();
        this.stackName = this.autoDetectStackName(instanceId);
        if (this.stackName == null) {
            throw new IllegalStateException("No stack resources found in stack for EC2 instance '" + instanceId + "'");
        }
    }

    @Override
    public String getStackName() {
        return this.stackName;
    }

    private String autoDetectStackName(String instanceId) {
        DescribeTagsResult describeTagsResult;
        Assert.notNull((Object)instanceId, (String)"No valid instance id defined");
        DescribeStackResourcesResult describeStackResourcesResult = this.amazonCloudFormationClient.describeStackResources(new DescribeStackResourcesRequest().withPhysicalResourceId(instanceId));
        if (describeStackResourcesResult != null && describeStackResourcesResult.getStackResources() != null && !describeStackResourcesResult.getStackResources().isEmpty()) {
            return ((StackResource)describeStackResourcesResult.getStackResources().get(0)).getStackName();
        }
        if (this.amazonEc2Client != null && (describeTagsResult = this.amazonEc2Client.describeTags(new DescribeTagsRequest().withFilters(new Filter[]{new Filter("resource-id", Collections.singletonList(instanceId)), new Filter("resource-type", Collections.singletonList("instance")), new Filter("key", Collections.singletonList("aws:cloudformation:stack-name"))}))) != null && describeTagsResult.getTags() != null && !describeTagsResult.getTags().isEmpty()) {
            return ((TagDescription)describeTagsResult.getTags().get(0)).getValue();
        }
        return null;
    }
}

