/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.external;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import io.higson.runtime.engine.util.EngineUtil;
import io.higson.runtime.profiler.jdbc.proxy.DataSourceProxy;
import io.higson.runtime.sql.DialectRegistry;
import io.higson.runtime.sql.RuntimeDialect;
import io.higson.runtime.sql.dialect.DialectParser;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.utils.PropertyProvider;

@Component
public class CoreExternalDataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(CoreExternalDataSourceProvider.class);
    public static final String HIGSON_RUNTIME_EXTERNAL_DATASOURCE_SQL_NAMES = "higson.runtime.external-datasource.sql.names";
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    private final String externalDatasources;
    private final PropertyProvider propertyProvider;
    private DataSource standardDataSource;

    public CoreExternalDataSourceProvider(@Value(value="${higson.runtime.external-datasource.sql.names:}") String externalDatasources, PropertyProvider propertyProvider) {
        this.externalDatasources = externalDatasources;
        this.propertyProvider = propertyProvider;
    }

    public void configure(DataSource dataSource) {
        this.standardDataSource = dataSource;
        if (StringUtils.isNotBlank((CharSequence)this.externalDatasources)) {
            Object[] codes = this.getDataSourceCodes(this.externalDatasources);
            if (log.isInfoEnabled()) {
                log.info("creating external datasources: {}", (Object)Arrays.toString(codes));
            }
            for (Object token : codes) {
                this.createDataSource((String)token);
            }
        }
    }

    public DataSource getDataSource(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return this.standardDataSource;
        }
        return this.dataSourceMap.get(code);
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    private String[] getDataSourceCodes(String text) {
        String[] tokens = EngineUtil.split((String)text, (char)',');
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    private void createDataSource(String dataSourceCode) {
        log.info("creating datasource: {}", (Object)dataSourceCode);
        String url = this.getProp("higson.runtime.external-datasource.sql.%s.url", dataSourceCode);
        String user = this.getProp("higson.runtime.external-datasource.sql.%s.username", dataSourceCode);
        String pass = this.getProp("higson.runtime.external-datasource.sql.%s.password", dataSourceCode);
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)user)) {
            log.warn("datasource {} - incomplete configuration, skipping...", (Object)dataSourceCode);
            return;
        }
        this.createDataSource(dataSourceCode, url, user, pass);
    }

    private void createDataSource(String dataSourceCode, String url, String user, String pass) {
        try {
            log.info("creating datasource with url:{}, user;{}", (Object)url, (Object)user);
            DataSource dataSource = this.createDataSource(url, user, pass);
            this.register(dataSourceCode, dataSource);
        }
        catch (PropertyVetoException | RuntimeException e) {
            log.error("failed to create datasource: " + dataSourceCode, (Throwable)e);
        }
    }

    private DataSource createDataSource(String url, String user, String pass) throws PropertyVetoException {
        ComboPooledDataSource ds = new ComboPooledDataSource();
        RuntimeDialect runtimeDialect = this.getExternalSourceDialect(url);
        ds.setDriverClass(runtimeDialect.jdbcDriverClassName());
        ds.setJdbcUrl(url);
        ds.setUser(user);
        ds.setPassword(pass);
        ds.setInitialPoolSize(1);
        ds.setMinPoolSize(1);
        ds.setMaxPoolSize(8);
        ds.setPreferredTestQuery(runtimeDialect.validationQuery());
        ds.setIdleConnectionTestPeriod(20);
        ds.setMaxConnectionAge(600);
        ds.setCheckoutTimeout(120000);
        ds.setUnreturnedConnectionTimeout(7200);
        return new DataSourceProxy((DataSource)ds);
    }

    private RuntimeDialect getExternalSourceDialect(String url) {
        String databaseDialect = DialectParser.getDatabaseDialect((String)url);
        log.debug("resolved dialect:{} from url:{}", (Object)databaseDialect, (Object)url);
        return DialectRegistry.getDialectFor((String)databaseDialect);
    }

    public void close() {
        for (Map.Entry<String, DataSource> e : this.dataSourceMap.entrySet()) {
            String code = e.getKey();
            DataSource dataSource = e.getValue();
            log.info("closing external datasource: {}", (Object)code);
            this.close(dataSource);
        }
    }

    private void close(DataSource dataSource) {
        if (dataSource instanceof ComboPooledDataSource) {
            try {
                ((ComboPooledDataSource)dataSource).close();
            }
            catch (RuntimeException e) {
                log.error("failed to close external datasource", (Throwable)e);
            }
        }
    }

    public Collection<String> getDataSourceCodes() {
        return new ArrayList<String>(this.dataSourceMap.keySet());
    }

    private void register(String code, DataSource dataSource) {
        log.info("registering datasource: {} -> {}", (Object)code, (Object)dataSource);
        this.dataSourceMap.put(code, dataSource);
    }

    private String getProp(String pattern, String dataSourceCode) {
        String propName = String.format(pattern, dataSourceCode);
        return this.propertyProvider.getProperty(propName);
    }

    public boolean hasExternalDataSourceWith(String externalSourceCode) {
        return this.dataSourceMap.containsKey(externalSourceCode);
    }
}

