/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public final class LoginConfiguration {
    private final int maxLoginAttempts;
    private final int coolDown;

    public LoginConfiguration(@Value(value="${higson.studio.security.login.attempts-limit:3}") int maxLoginAttempts, @Value(value="${higson.studio.security.login.attempts-cooldown:20}") int coolDown) {
        this.maxLoginAttempts = maxLoginAttempts;
        this.coolDown = coolDown;
    }

    public int getMaxLoginAttempts() {
        return this.maxLoginAttempts;
    }

    public int getCoolDown() {
        return this.coolDown;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginConfiguration)) {
            return false;
        }
        LoginConfiguration other = (LoginConfiguration)o;
        if (this.getMaxLoginAttempts() != other.getMaxLoginAttempts()) {
            return false;
        }
        return this.getCoolDown() == other.getCoolDown();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLoginAttempts();
        result = result * 59 + this.getCoolDown();
        return result;
    }

    public String toString() {
        return "LoginConfiguration(maxLoginAttempts=" + this.getMaxLoginAttempts() + ", coolDown=" + this.getCoolDown() + ")";
    }
}

