/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.dto;

import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import pl.decerto.hyperon.common.security.dto.SystemRole;

public class SystemRightDto {
    public static final Comparator<SystemRightDto> RIGHT_BY_CODE_ORDER = Comparator.comparing(SystemRightDto::getCode);
    private static final int MAX_NAME_LENGTH = 255;
    public static final String PROPERTY_CODE = "code";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_CREATE_DATE = "createDate";
    public static final String PROPERTY_ROLES = "roles";
    private Integer id;
    @NotNull(message="{common.notNull}")
    @Size(min=1, max=255, message="{common.incorrect.name.length}")
    private @NotNull(message="{common.notNull}") @Size(min=1, max=255, message="{common.incorrect.name.length}") String code = "";
    @Size(max=255, message="{common.incorrectDescription}")
    private @Size(max=255, message="{common.incorrectDescription}") String description = "";
    private Date createDate;
    private Set<SystemRole> roles = new HashSet<SystemRole>();

    public SystemRightDto(String code) {
        this.code = code;
    }

    public void setCode(String code) {
        this.code = code.toUpperCase();
    }

    public void add(SystemRole roleDto) {
        this.roles.add(roleDto);
    }

    public boolean isNewObject() {
        return this.getId() == null;
    }

    public SystemRightDto copy() {
        SystemRightDto sr = new SystemRightDto(this.code);
        sr.setId(this.id);
        sr.setDescription(this.description);
        sr.setCreateDate(this.createDate);
        return sr;
    }

    public Integer getId() {
        return this.id;
    }

    @NotNull(message="{common.notNull}")
    public @NotNull(message="{common.notNull}") String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Set<SystemRole> getRoles() {
        return this.roles;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setRoles(Set<SystemRole> roles) {
        this.roles = roles;
    }

    public String toString() {
        return "SystemRightDto(id=" + this.getId() + ", code=" + this.getCode() + ", description=" + this.getDescription() + ", createDate=" + this.getCreateDate() + ", roles=" + this.getRoles() + ")";
    }

    public SystemRightDto() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemRightDto)) {
            return false;
        }
        SystemRightDto other = (SystemRightDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemRightDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }
}

