/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.oauth2;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.web.filter.ForwardedHeaderFilter;
import pl.decerto.hyperon.common.security.oauth2.HyperonSecurityOAuth2Properties;
import pl.decerto.hyperon.common.security.oauth2.OAuth2PropertyCondition;

@Configuration
@ConfigurationPropertiesScan
@EnableConfigurationProperties
@OAuth2PropertyCondition
public class OAuth2SecurityConfiguration {
    private final HyperonSecurityOAuth2Properties properties;

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(this.properties.getClientRegistrations());
    }

    @Bean
    public JwtClaimValidator<List<String>> audienceValidator() {
        ClientRegistration client = this.properties.getClientRegistrations().get(0);
        return new JwtClaimValidator("aud", aud -> aud.contains(client.getClientId()));
    }

    @Bean
    public JwtTimestampValidator jwtTimestampValidator() {
        HyperonSecurityOAuth2Properties.Client client = this.properties.getClients().get(0);
        long liveTime = Long.parseLong(client.getTokenLiveTime());
        Duration duration = Duration.of(liveTime, ChronoUnit.SECONDS);
        return new JwtTimestampValidator(duration);
    }

    public HyperonSecurityOAuth2Properties getProperties() {
        return this.properties;
    }

    public OAuth2SecurityConfiguration(HyperonSecurityOAuth2Properties properties) {
        this.properties = properties;
    }

    @EnableWebSecurity
    @OAuth2PropertyCondition
    public static class OAuth2LoginSecurityConfig
    extends WebSecurityConfigurerAdapter {
        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.authorizeRequests(it -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)it.antMatchers(new String[]{"/login"})).permitAll().antMatchers(new String[]{"/app/**"})).authenticated().antMatchers(new String[]{"/api/**"})).authenticated()).oauth2Login(Customizer.withDefaults()).oauth2ResourceServer(OAuth2ResourceServerConfigurer::jwt).addFilterBefore((Filter)new ForwardedHeaderFilter(), WebAsyncManagerIntegrationFilter.class).exceptionHandling().and()).csrf().disable();
        }
    }
}

