/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.compare;

import java.util.Comparator;
import java.util.Objects;
import javax.validation.constraints.Size;

public class Comparer<E>
implements Comparator<E> {
    private static final String UNKNOWN_ELEMENTS_MESSAGE = "Attempt to compare elements unknown to Comparer";
    @Size(min=1)
    private @Size(min=1) E[] elementsInAscendingOrder;

    @SafeVarargs
    public Comparer(E ... elementsInAscendingOrder) {
        this.elementsInAscendingOrder = elementsInAscendingOrder;
    }

    public E min(E ... elements) {
        if (elements == null) {
            return null;
        }
        if (elements.length == 0) {
            return this.elementsInAscendingOrder[this.elementsInAscendingOrder.length - 1];
        }
        for (E element : this.elementsInAscendingOrder) {
            for (E arg : elements) {
                if (!Objects.equals(arg, element)) continue;
                return arg;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_ELEMENTS_MESSAGE);
    }

    public E max(E ... elements) {
        if (elements == null) {
            return null;
        }
        if (elements.length == 0) {
            return this.elementsInAscendingOrder[0];
        }
        for (int i = this.elementsInAscendingOrder.length - 1; i >= 0; --i) {
            for (E arg : elements) {
                if (!Objects.equals(arg, this.elementsInAscendingOrder[i])) continue;
                return arg;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_ELEMENTS_MESSAGE);
    }

    @Override
    public int compare(E o1, E o2) {
        if (Objects.equals(o1, o2)) {
            return 0;
        }
        for (E element : this.elementsInAscendingOrder) {
            if (Objects.equals(o1, element)) {
                return -1;
            }
            if (!Objects.equals(o2, element)) continue;
            return 1;
        }
        throw new IllegalArgumentException(UNKNOWN_ELEMENTS_MESSAGE);
    }
}

