/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.ByteString;
import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.Morph;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.Schema;
import io.protostuff.Tag;
import io.protostuff.WireFormat;
import io.protostuff.runtime.Delegate;
import io.protostuff.runtime.EnumIO;
import io.protostuff.runtime.Field;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.PolymorphicSchemaFactories;
import io.protostuff.runtime.RuntimeDerivativeField;
import io.protostuff.runtime.RuntimeFieldFactory;
import io.protostuff.runtime.RuntimeMessageField;
import io.protostuff.runtime.RuntimeObjectField;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public final class RuntimeReflectionFieldFactory {
    public static final RuntimeFieldFactory<Character> CHAR = new RuntimeFieldFactory<Character>(3){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            return new Field<T>(WireFormat.FieldType.UINT32, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        if (primitive) {
                            f.setChar(message, (char)input.readUInt32());
                        } else {
                            f.set(message, Character.valueOf((char)input.readUInt32()));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        if (primitive) {
                            output.writeUInt32(this.number, (int)f.getChar(message), false);
                        } else {
                            Character value = (Character)f.get(message);
                            if (value != null) {
                                output.writeUInt32(this.number, (int)value.charValue(), false);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeUInt32(this.number, input.readUInt32(), repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeUInt32(number, input.readUInt32(), repeated);
        }

        @Override
        public Character readFrom(Input input) throws IOException {
            return Character.valueOf((char)input.readUInt32());
        }

        @Override
        public void writeTo(Output output, int number, Character value, boolean repeated) throws IOException {
            output.writeUInt32(number, (int)value.charValue(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.UINT32;
        }

        @Override
        public Class<?> typeClass() {
            return Character.class;
        }
    };
    public static final RuntimeFieldFactory<Short> SHORT = new RuntimeFieldFactory<Short>(4){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            return new Field<T>(WireFormat.FieldType.UINT32, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        if (primitive) {
                            f.setShort(message, (short)input.readUInt32());
                        } else {
                            f.set(message, (short)input.readUInt32());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        if (primitive) {
                            output.writeUInt32(this.number, (int)f.getShort(message), false);
                        } else {
                            Short value = (Short)f.get(message);
                            if (value != null) {
                                output.writeUInt32(this.number, (int)value.shortValue(), false);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeUInt32(this.number, input.readUInt32(), repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeUInt32(number, input.readUInt32(), repeated);
        }

        @Override
        public Short readFrom(Input input) throws IOException {
            return (short)input.readUInt32();
        }

        @Override
        public void writeTo(Output output, int number, Short value, boolean repeated) throws IOException {
            output.writeUInt32(number, (int)value.shortValue(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.UINT32;
        }

        @Override
        public Class<?> typeClass() {
            return Short.class;
        }
    };
    public static final RuntimeFieldFactory<Byte> BYTE = new RuntimeFieldFactory<Byte>(2){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            return new Field<T>(WireFormat.FieldType.UINT32, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        if (primitive) {
                            f.setByte(message, (byte)input.readUInt32());
                        } else {
                            f.set(message, (byte)input.readUInt32());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        if (primitive) {
                            output.writeUInt32(this.number, (int)f.getByte(message), false);
                        } else {
                            Byte value = (Byte)f.get(message);
                            if (value != null) {
                                output.writeUInt32(this.number, (int)value.byteValue(), false);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeUInt32(this.number, input.readUInt32(), repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeUInt32(number, input.readUInt32(), repeated);
        }

        @Override
        public Byte readFrom(Input input) throws IOException {
            return (byte)input.readUInt32();
        }

        @Override
        public void writeTo(Output output, int number, Byte value, boolean repeated) throws IOException {
            output.writeUInt32(number, (int)value.byteValue(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.UINT32;
        }

        @Override
        public Class<?> typeClass() {
            return Byte.class;
        }
    };
    public static final RuntimeFieldFactory<Integer> INT32 = new RuntimeFieldFactory<Integer>(5){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            return new Field<T>(WireFormat.FieldType.INT32, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        if (primitive) {
                            f.setInt(message, input.readInt32());
                        } else {
                            f.set(message, input.readInt32());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        if (primitive) {
                            output.writeInt32(this.number, f.getInt(message), false);
                        } else {
                            Integer value = (Integer)f.get(message);
                            if (value != null) {
                                output.writeInt32(this.number, value.intValue(), false);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeInt32(this.number, input.readInt32(), repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeInt32(number, input.readInt32(), repeated);
        }

        @Override
        public Integer readFrom(Input input) throws IOException {
            return input.readInt32();
        }

        @Override
        public void writeTo(Output output, int number, Integer value, boolean repeated) throws IOException {
            output.writeInt32(number, value.intValue(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.INT32;
        }

        @Override
        public Class<?> typeClass() {
            return Integer.class;
        }
    };
    public static final RuntimeFieldFactory<Long> INT64 = new RuntimeFieldFactory<Long>(6){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            return new Field<T>(WireFormat.FieldType.INT64, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        if (primitive) {
                            f.setLong(message, input.readInt64());
                        } else {
                            f.set(message, input.readInt64());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        if (primitive) {
                            output.writeInt64(this.number, f.getLong(message), false);
                        } else {
                            Long value = (Long)f.get(message);
                            if (value != null) {
                                output.writeInt64(this.number, value.longValue(), false);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeInt64(this.number, input.readInt64(), repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeInt64(number, input.readInt64(), repeated);
        }

        @Override
        public Long readFrom(Input input) throws IOException {
            return input.readInt64();
        }

        @Override
        public void writeTo(Output output, int number, Long value, boolean repeated) throws IOException {
            output.writeInt64(number, value.longValue(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.INT64;
        }

        @Override
        public Class<?> typeClass() {
            return Long.class;
        }
    };
    public static final RuntimeFieldFactory<Float> FLOAT = new RuntimeFieldFactory<Float>(7){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            return new Field<T>(WireFormat.FieldType.FLOAT, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        if (primitive) {
                            f.setFloat(message, input.readFloat());
                        } else {
                            f.set(message, new Float(input.readFloat()));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        if (primitive) {
                            output.writeFloat(this.number, f.getFloat(message), false);
                        } else {
                            Float value = (Float)f.get(message);
                            if (value != null) {
                                output.writeFloat(this.number, value.floatValue(), false);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeFloat(this.number, input.readFloat(), repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFloat(number, input.readFloat(), repeated);
        }

        @Override
        public Float readFrom(Input input) throws IOException {
            return new Float(input.readFloat());
        }

        @Override
        public void writeTo(Output output, int number, Float value, boolean repeated) throws IOException {
            output.writeFloat(number, value.floatValue(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FLOAT;
        }

        @Override
        public Class<?> typeClass() {
            return Float.class;
        }
    };
    public static final RuntimeFieldFactory<Double> DOUBLE = new RuntimeFieldFactory<Double>(8){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            return new Field<T>(WireFormat.FieldType.DOUBLE, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        if (primitive) {
                            f.setDouble(message, input.readDouble());
                        } else {
                            f.set(message, new Double(input.readDouble()));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        if (primitive) {
                            output.writeDouble(this.number, f.getDouble(message), false);
                        } else {
                            Double value = (Double)f.get(message);
                            if (value != null) {
                                output.writeDouble(this.number, value.doubleValue(), false);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeDouble(this.number, input.readDouble(), repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeDouble(number, input.readDouble(), repeated);
        }

        @Override
        public Double readFrom(Input input) throws IOException {
            return new Double(input.readDouble());
        }

        @Override
        public void writeTo(Output output, int number, Double value, boolean repeated) throws IOException {
            output.writeDouble(number, value.doubleValue(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.DOUBLE;
        }

        @Override
        public Class<?> typeClass() {
            return Double.class;
        }
    };
    public static final RuntimeFieldFactory<Boolean> BOOL = new RuntimeFieldFactory<Boolean>(1){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            final boolean primitive = f.getType().isPrimitive();
            return new Field<T>(WireFormat.FieldType.BOOL, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        if (primitive) {
                            f.setBoolean(message, input.readBool());
                        } else {
                            f.set(message, input.readBool() ? Boolean.TRUE : Boolean.FALSE);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        if (primitive) {
                            output.writeBool(this.number, f.getBoolean(message), false);
                        } else {
                            Boolean value = (Boolean)f.get(message);
                            if (value != null) {
                                output.writeBool(this.number, value.booleanValue(), false);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeBool(this.number, input.readBool(), repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeBool(number, input.readBool(), repeated);
        }

        @Override
        public Boolean readFrom(Input input) throws IOException {
            return input.readBool() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public void writeTo(Output output, int number, Boolean value, boolean repeated) throws IOException {
            output.writeBool(number, value.booleanValue(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.BOOL;
        }

        @Override
        public Class<?> typeClass() {
            return Boolean.class;
        }
    };
    public static final RuntimeFieldFactory<String> STRING = new RuntimeFieldFactory<String>(9){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            return new Field<T>(WireFormat.FieldType.STRING, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        f.set(message, input.readString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        CharSequence value = (CharSequence)f.get(message);
                        if (value != null) {
                            output.writeString(this.number, value, false);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, true, this.number, repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, true, number, repeated);
        }

        @Override
        public String readFrom(Input input) throws IOException {
            return input.readString();
        }

        @Override
        public void writeTo(Output output, int number, String value, boolean repeated) throws IOException {
            output.writeString(number, (CharSequence)value, repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.STRING;
        }

        @Override
        public Class<?> typeClass() {
            return String.class;
        }
    };
    public static final RuntimeFieldFactory<ByteString> BYTES = new RuntimeFieldFactory<ByteString>(10){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            return new Field<T>(WireFormat.FieldType.BYTES, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        f.set(message, input.readBytes());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        ByteString bs = (ByteString)f.get(message);
                        if (bs != null) {
                            output.writeBytes(this.number, bs, false);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, false, this.number, repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, false, number, repeated);
        }

        @Override
        public ByteString readFrom(Input input) throws IOException {
            return input.readBytes();
        }

        @Override
        public void writeTo(Output output, int number, ByteString value, boolean repeated) throws IOException {
            output.writeBytes(number, value, repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.BYTES;
        }

        @Override
        public Class<?> typeClass() {
            return ByteString.class;
        }
    };
    public static final RuntimeFieldFactory<byte[]> BYTE_ARRAY = new RuntimeFieldFactory<byte[]>(11){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            return new Field<T>(WireFormat.FieldType.BYTES, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        f.set(message, input.readByteArray());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        byte[] array = (byte[])f.get(message);
                        if (array != null) {
                            output.writeByteArray(this.number, array, false);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, false, this.number, repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, false, number, repeated);
        }

        @Override
        public byte[] readFrom(Input input) throws IOException {
            return input.readByteArray();
        }

        @Override
        public void writeTo(Output output, int number, byte[] value, boolean repeated) throws IOException {
            output.writeByteArray(number, value, repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.BYTES;
        }

        @Override
        public Class<?> typeClass() {
            return byte[].class;
        }
    };
    public static final RuntimeFieldFactory<Integer> ENUM = new RuntimeFieldFactory<Integer>(24){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, final IdStrategy strategy) {
            final EnumIO<? extends Enum<?>> eio = strategy.getEnumIO(f.getType());
            return new Field<T>(WireFormat.FieldType.ENUM, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        f.set(message, eio.readFrom(input));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    Enum existing;
                    try {
                        existing = (Enum)f.get(message);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (existing != null) {
                        eio.writeTo(output, this.number, this.repeated, existing);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    EnumIO.transfer(pipe, input, output, this.number, repeated, strategy);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(Output output, int number, Integer value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };
    static final RuntimeFieldFactory<Object> POJO = new RuntimeFieldFactory<Object>(127){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            Class<?> type = f.getType();
            return new RuntimeMessageField<T, Object>(type, strategy.getSchemaWrapper(type, true), WireFormat.FieldType.MESSAGE, number, name, false, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3, x4, x5, x6);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        f.set(message, input.mergeObject(f.get(message), this.getSchema()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    Object existing;
                    try {
                        existing = f.get(message);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (existing != null) {
                        output.writeObject(this.number, existing, this.getSchema(), false);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeObject(this.number, (Object)pipe, this.getPipeSchema(), repeated);
                }

                @Override
                protected Field<T> copy(IdStrategy strategy) {
                    return RuntimeFieldFactory.POJO.create(this.number, this.name, f, strategy);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(Output output, int number, Object value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };
    static final RuntimeFieldFactory<Object> POLYMORPHIC_POJO = new RuntimeFieldFactory<Object>(0){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            if (14.pojo(f.getType(), f.getAnnotation(Morph.class), strategy)) {
                return POJO.create(number, name, f, strategy);
            }
            return new RuntimeDerivativeField<T>(f.getType(), WireFormat.FieldType.MESSAGE, number, name, false, f.getAnnotation(Tag.class), strategy){
                {
                    super(x0, x1, x2, x3, x4, x5, x6);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    Object value = input.mergeObject(message, (Schema)this.schema);
                    if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                        try {
                            f.set(message, value);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    Object existing;
                    try {
                        existing = f.get(message);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (existing != null) {
                        output.writeObject(this.number, existing, (Schema)this.schema, false);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeObject(this.number, (Object)pipe, this.schema.pipeSchema, false);
                }

                @Override
                public void doMergeFrom(Input input, Schema<Object> schema, Object message) throws IOException {
                    try {
                        Object value;
                        Object existing = f.get(message);
                        Object object = value = existing == null || existing.getClass() != schema.typeClass() ? schema.newMessage() : existing;
                        if (input instanceof GraphInput) {
                            ((GraphInput)input).updateLast(value, message);
                        }
                        schema.mergeFrom(input, value);
                        f.set(message, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                protected Field<T> copy(IdStrategy strategy) {
                    return RuntimeFieldFactory.POLYMORPHIC_POJO.create(this.number, this.name, f, strategy);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(Output output, int number, Object value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };
    static final RuntimeFieldFactory<Object> OBJECT = new RuntimeFieldFactory<Object>(16){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            return new RuntimeObjectField<T>(f.getType(), WireFormat.FieldType.MESSAGE, number, name, false, f.getAnnotation(Tag.class), PolymorphicSchemaFactories.getFactoryFromField(f, strategy), strategy){
                {
                    super(x0, x1, x2, x3, x4, x5, x6, x7);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    Object value = input.mergeObject(message, (Schema)this.schema);
                    if (input instanceof GraphInput && ((GraphInput)input).isCurrentMessageReference()) {
                        try {
                            f.set(message, value);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    Object existing;
                    try {
                        existing = f.get(message);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (existing != null) {
                        output.writeObject(this.number, existing, (Schema)this.schema, false);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeObject(this.number, (Object)pipe, this.schema.getPipeSchema(), false);
                }

                @Override
                public void setValue(Object value, Object message) {
                    try {
                        f.set(message, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                protected Field<T> copy(IdStrategy strategy) {
                    return RuntimeFieldFactory.OBJECT.create(this.number, this.name, f, strategy);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(Output output, int number, Object value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.MESSAGE;
        }

        @Override
        public Class<?> typeClass() {
            return Object.class;
        }
    };
    public static final RuntimeFieldFactory<BigDecimal> BIGDECIMAL = new RuntimeFieldFactory<BigDecimal>(12){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            return new Field<T>(WireFormat.FieldType.STRING, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        f.set(message, new BigDecimal(input.readString()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        BigDecimal value = (BigDecimal)f.get(message);
                        if (value != null) {
                            output.writeString(this.number, (CharSequence)value.toString(), false);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, true, this.number, repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, true, number, repeated);
        }

        @Override
        public BigDecimal readFrom(Input input) throws IOException {
            return new BigDecimal(input.readString());
        }

        @Override
        public void writeTo(Output output, int number, BigDecimal value, boolean repeated) throws IOException {
            output.writeString(number, (CharSequence)value.toString(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.STRING;
        }

        @Override
        public Class<?> typeClass() {
            return BigDecimal.class;
        }
    };
    public static final RuntimeFieldFactory<BigInteger> BIGINTEGER = new RuntimeFieldFactory<BigInteger>(13){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            return new Field<T>(WireFormat.FieldType.BYTES, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        f.set(message, new BigInteger(input.readByteArray()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        BigInteger value = (BigInteger)f.get(message);
                        if (value != null) {
                            output.writeByteArray(this.number, value.toByteArray(), false);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    input.transferByteRangeTo(output, false, this.number, repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            input.transferByteRangeTo(output, false, number, repeated);
        }

        @Override
        public BigInteger readFrom(Input input) throws IOException {
            return new BigInteger(input.readByteArray());
        }

        @Override
        public void writeTo(Output output, int number, BigInteger value, boolean repeated) throws IOException {
            output.writeByteArray(number, value.toByteArray(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.BYTES;
        }

        @Override
        public Class<?> typeClass() {
            return BigInteger.class;
        }
    };
    public static final RuntimeFieldFactory<Date> DATE = new RuntimeFieldFactory<Date>(14){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            return new Field<T>(WireFormat.FieldType.FIXED64, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    try {
                        f.set(message, new Date(input.readFixed64()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    try {
                        Date value = (Date)f.get(message);
                        if (value != null) {
                            output.writeFixed64(this.number, value.getTime(), false);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    output.writeFixed64(this.number, input.readFixed64(), repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            output.writeFixed64(number, input.readFixed64(), repeated);
        }

        @Override
        public Date readFrom(Input input) throws IOException {
            return new Date(input.readFixed64());
        }

        @Override
        public void writeTo(Output output, int number, Date value, boolean repeated) throws IOException {
            output.writeFixed64(number, value.getTime(), repeated);
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            return WireFormat.FieldType.FIXED64;
        }

        @Override
        public Class<?> typeClass() {
            return Date.class;
        }
    };
    public static final RuntimeFieldFactory<Object> DELEGATE = new RuntimeFieldFactory<Object>(30){

        @Override
        public <T> Field<T> create(int number, String name, final java.lang.reflect.Field f, IdStrategy strategy) {
            final Delegate<?> delegate = strategy.getDelegate(f.getType());
            return new Field<T>(WireFormat.FieldType.BYTES, number, name, f.getAnnotation(Tag.class)){
                {
                    super(x0, x1, x2, x3);
                    f.setAccessible(true);
                }

                @Override
                public void mergeFrom(Input input, T message) throws IOException {
                    Object value = delegate.readFrom(input);
                    try {
                        f.set(message, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void writeTo(Output output, T message) throws IOException {
                    Object value;
                    try {
                        value = f.get(message);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (value != null) {
                        delegate.writeTo(output, this.number, value, false);
                    }
                }

                @Override
                public void transfer(Pipe pipe, Input input, Output output, boolean repeated) throws IOException {
                    delegate.transfer(pipe, input, output, this.number, repeated);
                }
            };
        }

        @Override
        public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object readFrom(Input input) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(Output output, int number, Object value, boolean repeated) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WireFormat.FieldType getFieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> typeClass() {
            throw new UnsupportedOperationException();
        }
    };

    private RuntimeReflectionFieldFactory() {
    }
}

