/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.internal.Nullable;
import brave.internal.Throwables;
import brave.jms.JmsTracing;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;

final class MessageParser {
    MessageParser() {
    }

    @Nullable
    static Destination destination(Message message) {
        try {
            return message.getJMSDestination();
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error getting destination of message {0}", message, null);
            return null;
        }
    }

    @Nullable
    static String messageId(Message message) {
        try {
            return message.getJMSMessageID();
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error getting getJMSMessageID of message {0}", message, null);
            return null;
        }
    }

    @Nullable
    static String channelKind(@Nullable Destination destination) {
        if (destination == null) {
            return null;
        }
        return MessageParser.isQueue(destination) ? "queue" : "topic";
    }

    static boolean isQueue(@Nullable Destination destination) {
        boolean isQueue = destination instanceof Queue;
        boolean isTopic = destination instanceof Topic;
        if (isQueue && isTopic) {
            try {
                isQueue = ((Queue)destination).getQueueName() != null;
            }
            catch (Throwable t) {
                Throwables.propagateIfFatal((Throwable)t);
                JmsTracing.log(t, "error getting destination name from {0}", destination, null);
            }
        }
        return isQueue;
    }

    @Nullable
    static String channelName(@Nullable Destination destination) {
        if (destination == null) {
            return null;
        }
        boolean isQueue = MessageParser.isQueue(destination);
        try {
            if (isQueue) {
                return ((Queue)destination).getQueueName();
            }
            return ((Topic)destination).getTopicName();
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error getting destination name from {0}", destination, null);
            return null;
        }
    }
}

