/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.internal.Nullable;
import brave.jms.JmsTracing;
import brave.messaging.MessagingRequest;
import brave.messaging.ProducerRequest;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;

abstract class TracingProducer<R extends ProducerRequest> {
    final JmsTracing jmsTracing;
    final Tracer tracer;
    final CurrentTraceContext current;
    final TraceContext.Extractor<R> extractor;
    final TraceContext.Injector<R> injector;
    final SamplerFunction<MessagingRequest> sampler;
    @Nullable
    final String remoteServiceName;

    TracingProducer(TraceContext.Extractor<R> extractor, TraceContext.Injector<R> injector, JmsTracing jmsTracing) {
        this.jmsTracing = jmsTracing;
        this.tracer = jmsTracing.tracing.tracer();
        this.current = jmsTracing.tracing.currentTraceContext();
        this.extractor = extractor;
        this.injector = injector;
        this.sampler = jmsTracing.producerSampler;
        this.remoteServiceName = jmsTracing.remoteServiceName;
    }

    Span createAndStartProducerSpan(R request) {
        Span span;
        TraceContext maybeParent = this.current.get();
        if (maybeParent == null) {
            TraceContextOrSamplingFlags extracted = this.extractor.extract(request);
            span = this.jmsTracing.nextMessagingSpan(this.sampler, (MessagingRequest)request, extracted);
        } else {
            span = this.tracer.newChild(maybeParent);
        }
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).name("send");
            this.jmsTracing.tagQueueOrTopic((MessagingRequest)request, (SpanCustomizer)span);
            if (this.remoteServiceName != null) {
                span.remoteServiceName(this.remoteServiceName);
            }
            span.start();
        }
        this.injector.inject(span.context(), request);
        return span;
    }
}

