/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.paramstore;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import io.awspring.cloud.autoconfigure.paramstore.AwsParamStoreConfigDataResource;
import io.awspring.cloud.paramstore.AwsParamStorePropertySource;
import io.awspring.cloud.paramstore.AwsParamStorePropertySources;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.util.ReflectionUtils;

public class AwsParamStoreConfigDataLoader
implements ConfigDataLoader<AwsParamStoreConfigDataResource> {
    private final DeferredLogFactory logFactory;

    public AwsParamStoreConfigDataLoader(DeferredLogFactory logFactory) {
        this.logFactory = logFactory;
        this.reconfigureLoggers(logFactory);
    }

    public ConfigData load(ConfigDataLoaderContext context, AwsParamStoreConfigDataResource resource) {
        try {
            AWSSimpleSystemsManagement ssm = (AWSSimpleSystemsManagement)context.getBootstrapContext().get(AWSSimpleSystemsManagement.class);
            AwsParamStorePropertySource propertySource = resource.getPropertySources().createPropertySource(resource.getContext(), resource.isOptional(), ssm);
            if (propertySource != null) {
                return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
    }

    private void reconfigureLoggers(DeferredLogFactory logFactory) {
        List<Class> loggers = Arrays.asList(AwsParamStorePropertySource.class, AwsParamStorePropertySources.class);
        loggers.forEach(it -> AwsParamStoreConfigDataLoader.reconfigureLogger(it, logFactory));
    }

    static void reconfigureLogger(Class<?> type, DeferredLogFactory logFactory) {
        ReflectionUtils.doWithFields(type, field -> {
            field.setAccessible(true);
            field.set(null, logFactory.getLog(type));
        }, AwsParamStoreConfigDataLoader::isUpdateableLogField);
    }

    private static boolean isUpdateableLogField(Field field) {
        return !Modifier.isFinal(field.getModifiers()) && field.getType().isAssignableFrom(Log.class);
    }
}

