/*
 * Decompiled with CFR 0.152.
 */
package brave.rpc;

import brave.SpanCustomizer;
import brave.propagation.TraceContext;
import brave.rpc.RpcRequest;
import brave.rpc.RpcTags;

public interface RpcRequestParser {
    public static final RpcRequestParser DEFAULT = new Default();

    public void parse(RpcRequest var1, TraceContext var2, SpanCustomizer var3);

    public static class Default
    implements RpcRequestParser {
        @Override
        public void parse(RpcRequest req, TraceContext context, SpanCustomizer span) {
            String service = req.service();
            String method = req.method();
            if (service == null && method == null) {
                return;
            }
            if (service == null) {
                span.tag(RpcTags.METHOD.key(), method);
                span.name(method);
            } else if (method == null) {
                span.tag(RpcTags.SERVICE.key(), service);
                span.name(service);
            } else {
                span.tag(RpcTags.SERVICE.key(), service);
                span.tag(RpcTags.METHOD.key(), method);
                span.name(service + "/" + method);
            }
        }
    }
}

