/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.cache;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileCache {
    private static final Logger log = LoggerFactory.getLogger(ProfileCache.class);
    private final Map<CacheKey, String> cache = new ConcurrentHashMap<CacheKey, String>();

    public void put(@NotNull String regionCode, String version, @NotNull String profile) {
        CacheKey cacheKey = new CacheKey(regionCode, version);
        if (log.isDebugEnabled()) {
            log.debug("Caching profile: {} for key: {}", (Object)profile, (Object)cacheKey);
        }
        this.cache.put(cacheKey, profile);
    }

    public String get(@NotNull String regionCode, String version) {
        CacheKey cacheKey = new CacheKey(regionCode, version);
        if (log.isDebugEnabled()) {
            log.debug("Getting cached profile for key: {}", (Object)cacheKey);
        }
        return this.cache.get(cacheKey);
    }

    public void invalidate(@NotNull String regionCode, String version) {
        CacheKey cacheKey = new CacheKey(regionCode, version);
        if (log.isDebugEnabled()) {
            log.debug("Invalidating cached profile with key: {}", (Object)cacheKey);
        }
        this.cache.remove(cacheKey);
    }

    public Set<CacheKey> getAllKeys() {
        return this.cache.keySet();
    }

    public static final class CacheKey {
        private final String regionCode;
        private final String version;

        public CacheKey(String regionCode, String version) {
            this.regionCode = StringUtils.upperCase((String)regionCode);
            this.version = StringUtils.upperCase((String)version);
        }

        public String getRegionCode() {
            return this.regionCode;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "ProfileCache.CacheKey(regionCode=" + this.getRegionCode() + ", version=" + this.getVersion() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            String this$regionCode = this.getRegionCode();
            String other$regionCode = other.getRegionCode();
            if (this$regionCode == null ? other$regionCode != null : !this$regionCode.equals(other$regionCode)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $regionCode = this.getRegionCode();
            result = result * 59 + ($regionCode == null ? 43 : $regionCode.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }
    }
}

