/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.decoder;

import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.decoder.CascadeArg;
import io.higson.runtime.decoder.CascadeArgType;
import io.higson.runtime.decoder.FunctionCascadeParser;
import io.higson.runtime.decoder.FunctionCascadeRequest;
import io.higson.runtime.decoder.ParamCascadeParser;
import io.higson.runtime.decoder.ParamCascadeRequest;
import io.higson.runtime.decoder.ValueExtractor;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.core.decoder.StandardDecoder;
import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.helper.TypeConverter;
import io.higson.runtime.rhino.value.RhinoMultiValue;
import io.higson.runtime.rhino.value.RhinoParamValue;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadeDecoder
extends StandardDecoder {
    private static final Logger log = LoggerFactory.getLogger(CascadeDecoder.class);
    private final TypeConverter converter = TypeConverter.getInstance();
    private final FunctionCascadeParser functionParser = new FunctionCascadeParser();
    private final ParamCascadeParser paramParser = new ParamCascadeParser();
    private final ValueExtractor extractor = new ValueExtractor();
    private final HigsonEngine engine;

    public CascadeDecoder(HigsonEngine engine) {
        this.engine = engine;
    }

    @Override
    public ValueHolder decode(String text, Type<?> type, ParamContext ctx) {
        if (text != null && text.length() > 3 && text.indexOf(36) >= 0) {
            if ((text = text.trim()).startsWith("$f ")) {
                String ref = text.substring(3);
                return this.cascadeToFunction(ref, type, ctx);
            }
            if (text.startsWith("$p ")) {
                String ref = text.substring(3);
                return this.cascadeToParameter(ref, type, ctx);
            }
        }
        return super.decode(text, type, ctx);
    }

    public Object cascadeCall(String functionCode, ParamContext ctx) {
        return this.cascadeToFunction(functionCode, ctx);
    }

    public Object cascadeCall(String functionCode, Type<?> type, ParamContext ctx) {
        Object obj = this.cascadeCall(functionCode, ctx);
        if (this.isCompoundType(obj)) {
            return obj;
        }
        return this.convert(obj, type);
    }

    public ValueHolder cascadeGet(String parameterCode, Type<?> type, ParamContext ctx) {
        return this.cascadeToParameter(parameterCode, type, ctx);
    }

    public ValueHolder[] cascadeGet(String parameterCode, ParamContext ctx) {
        return this.cascadeToParameter(ctx, parameterCode);
    }

    public MultiValue[] cascadeGetMultiValues(String parameterCode, ParamContext ctx) {
        ParamCascadeRequest request = this.paramParser.parse(parameterCode);
        ParamValue pv = this.engine.get(request.getParamCode(), ctx);
        if (pv == null || pv.isEmpty()) {
            return null;
        }
        return (MultiValue[])pv.rows().stream().map(mv -> new MultiValue(request.getOutputCode() != null ? mv.getHolder(request.getOutputCode()) : mv.getHolder(request.getOutputIndex()))).toArray(MultiValue[]::new);
    }

    private ValueHolder cascadeToParameter(String parameterCode, Type<?> type, ParamContext ctx) {
        ValueHolder holder = this.cascadeToParameter(parameterCode, ctx);
        return this.convert(holder, type);
    }

    private ValueHolder cascadeToParameter(String parameterCode, ParamContext ctx) {
        ParamCascadeRequest request = this.paramParser.parse(parameterCode);
        ParamValue pv = this.engine.get(request.getParamCode(), ctx);
        if (pv == null) {
            return null;
        }
        ValueHolder value = request.getOutputCode() != null ? pv.getHolder(request.getOutputCode()) : pv.getHolder(request.getOutputIndex());
        return value;
    }

    private ValueHolder[] cascadeToParameter(ParamContext ctx, String parameterCode) {
        ParamCascadeRequest request = this.paramParser.parse(parameterCode);
        ParamValue pv = this.engine.get(request.getParamCode(), ctx);
        if (pv == null) {
            return new ValueHolder[0];
        }
        return this.extractHolders(request, pv);
    }

    private ValueHolder[] extractHolders(ParamCascadeRequest request, ParamValue pv) {
        if (request.getOutputCode() != null) {
            return this.extractByCode(request, pv);
        }
        return this.extractByIndex(request, pv);
    }

    private ValueHolder[] extractByIndex(ParamCascadeRequest request, ParamValue pv) {
        return (ValueHolder[])pv.stream().map(value -> value.getHolder(request.getOutputIndex())).toArray(ValueHolder[]::new);
    }

    private ValueHolder[] extractByCode(ParamCascadeRequest request, ParamValue pv) {
        if (pv.isEmpty()) {
            return new ValueHolder[]{null};
        }
        return (ValueHolder[])pv.stream().map(mv -> mv.getHolder(request.getOutputCode())).toArray(ValueHolder[]::new);
    }

    private ValueHolder cascadeToFunction(String functionCode, Type<?> type, ParamContext ctx) {
        Object result = this.cascadeToFunction(functionCode, ctx);
        return this.convert(result, type);
    }

    private Object cascadeToFunction(String functionCode, ParamContext ctx) {
        FunctionCascadeRequest request = this.functionParser.parse(functionCode);
        Object[] args = this.resolveArgs(request.getArgs(), ctx);
        Object result = this.engine.call(request.getFunctionCode(), ctx, args);
        if (request.getOutputCode() != null) {
            result = this.extractor.extract(result, request.getOutputCode());
        } else if (request.getOutputIndex() != null) {
            result = this.extractor.extract(result, request.getOutputIndex());
        }
        return result;
    }

    private boolean isCompoundType(Object obj) {
        return obj instanceof ParamValue || obj instanceof RhinoParamValue || obj instanceof MultiValue || obj instanceof RhinoMultiValue || obj instanceof Collection || obj instanceof Object[];
    }

    private Object[] resolveArgs(CascadeArg[] args, ParamContext ctx) {
        if (args == null || args.length == 0) {
            return null;
        }
        Object[] resolved = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            resolved[i] = this.resolveCascadeArg(args[i], ctx);
        }
        return resolved;
    }

    private Object resolveCascadeArg(CascadeArg arg, ParamContext ctx) {
        CascadeArgType type = arg.getType();
        if (type == CascadeArgType.LITERAL) {
            return arg.getValue();
        }
        if (type == CascadeArgType.CONTEXT) {
            return this.resolveContextArg(ctx, arg.getValue());
        }
        throw new HigsonRuntimeException("Cascade call with " + type + " is not supported");
    }

    private Object resolveContextArg(ParamContext ctx, String path) {
        if (ctx instanceof HigsonContext) {
            return ((HigsonContext)ctx).get(path);
        }
        throw new HigsonRuntimeException("Using cascade function with context args is allowed only with MppContext");
    }

    private ValueHolder convert(Object obj, Type<?> type) {
        Class<?> clazz = type.getClass();
        if (clazz == HigsonContext.getStringType().getClass()) {
            return this.converter.toStringHolder(obj);
        }
        if (clazz == HigsonContext.getNumberType().getClass()) {
            return this.converter.toNumberHolder(obj);
        }
        if (clazz == HigsonContext.getIntegerType().getClass()) {
            return this.converter.toIntegerHolder(obj);
        }
        if (clazz == HigsonContext.getBooleanType().getClass()) {
            return this.converter.toBooleanHolder(obj);
        }
        if (clazz == HigsonContext.getDateType().getClass()) {
            return this.converter.toDateHolder(obj);
        }
        if (clazz == HigsonContext.getDatetimeType().getClass()) {
            return this.converter.toDatetimeHolder(obj);
        }
        log.warn("conversion not supported for type: {}", type);
        return this.converter.toStringHolder(obj);
    }
}

