/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.date;

import io.higson.runtime.engine.core.type.AbstractValueHolder;
import io.higson.runtime.engine.types.date.DateTimeFormatterPool;
import io.higson.runtime.engine.types.date.LocalDateType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class LocalDateHolder
extends AbstractValueHolder {
    private final LocalDate localDate;

    @Override
    public LocalDate getValue() {
        return this.localDate;
    }

    @Override
    public Date getDate() {
        return this.localDate != null ? Date.from(this.localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()) : null;
    }

    @Override
    public Date getDatetime() {
        return this.localDate != null ? Date.from(this.localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()) : null;
    }

    @Override
    public LocalDate getLocalDate() {
        return this.localDate;
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        return this.localDate == null ? null : this.localDate.atStartOfDay();
    }

    @Override
    public Long getLong() {
        return this.localDate != null ? Long.valueOf(this.localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli()) : null;
    }

    @Override
    public long longValue() {
        return this.localDate != null ? this.localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli() : 0L;
    }

    @Override
    public String getString() {
        return this.getString(LocalDateType.getDefaultOutputPattern());
    }

    public String getString(String pattern) {
        return this.localDate != null ? DateTimeFormatterPool.ofPattern(pattern).format(this.localDate) : null;
    }

    public LocalDateHolder(LocalDate localDate) {
        this.localDate = localDate;
    }
}

