/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.function.groovy.shell;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import io.higson.runtime.function.groovy.shell.CachedGroovyShell;
import io.higson.runtime.function.groovy.shell.CompiledGroovyFunction;
import io.higson.runtime.invoker.MppGroovyShellConfiguration;
import io.higson.runtime.model.GroovyFunction;
import java.security.AccessController;
import java.security.CodeSource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.messages.Message;

class CompilationResultVerifier {
    public static final String GROOVY_PROCESS_EXECUTE_REGEX = "(\\s+)?(\")?(.*)(\")?(\\s+)?\\.(\\s+)?(execute)(\\s+)?\\((\\s+)?";
    private static final Pattern COMPILED_GROOVY_EXECUTE_REGEX = Pattern.compile("(\\s+)?(\")?(.*)(\")?(\\s+)?\\.(\\s+)?(execute)(\\s+)?\\((\\s+)?");
    private static final String DEFAULT_CODE_BASE = "/groovy/shell";
    private static final CompilerConfiguration CONFIGURATION = MppGroovyShellConfiguration.secureConfiguration();
    private final GroovyClassLoader loader;

    CompilationResultVerifier() {
        ClassLoader parentLoader = CachedGroovyShell.class.getClassLoader();
        this.loader = AccessController.doPrivileged(() -> new GroovyClassLoader(parentLoader, CONFIGURATION));
    }

    void verify(GroovyFunction function) {
        ErrorCollector collector = new ErrorCollector(CONFIGURATION);
        CompiledGroovyFunction groovyFunction = this.compile(function);
        this.verifyBody(collector, groovyFunction);
    }

    private CompiledGroovyFunction compile(GroovyFunction function) {
        String body = function.getBody();
        String fileName = function.getVirtualName();
        GroovyCodeSource gcs = new GroovyCodeSource(body, fileName, DEFAULT_CODE_BASE);
        Class compiled = this.loader.parseClass(gcs, false);
        return new CompiledGroovyFunction(function.getImplId(), fileName, gcs, compiled, null);
    }

    private void verifyBody(ErrorCollector collector, CompiledGroovyFunction compiledFunction) {
        GroovyCodeSource source = compiledFunction.getSource();
        String scriptText = source.getScriptText();
        CodeSource codeSource = source.getCodeSource();
        CompilationUnit compilationUnit = new CompilationUnit(CONFIGURATION, codeSource, this.loader);
        this.findProcessExecuteExpression(collector, scriptText, compilationUnit);
        if (collector.hasErrors()) {
            throw new MultipleCompilationErrorsException(collector);
        }
    }

    private void findProcessExecuteExpression(ErrorCollector collector, String scriptText, CompilationUnit compilationUnit) {
        Matcher matcher = COMPILED_GROOVY_EXECUTE_REGEX.matcher(scriptText);
        if (matcher.find()) {
            this.addError(collector, compilationUnit, "java.lang.Process");
        }
    }

    private void addError(ErrorCollector collector, CompilationUnit compilationUnit, String it) {
        String message = String.format("Property access not allowed on [%s]", it);
        collector.addError(Message.create((String)message, (ProcessingUnit)compilationUnit));
    }
}

