/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.invoker;

import io.higson.runtime.engine.core.context.DefaultContext;
import io.higson.runtime.engine.core.function.Function;
import io.higson.runtime.engine.core.function.FunctionInvoker;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.model.PropFunction;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropFunctionInvoker
implements FunctionInvoker {
    private static final Logger log = LoggerFactory.getLogger(PropFunctionInvoker.class);

    @Override
    public Object invoke(Function function, Object ... args) {
        PropFunction f = this.cast(function);
        if (args.length == 1 && args[0] instanceof DefaultContext) {
            DefaultContext ctx = (DefaultContext)args[0];
            if (log.isTraceEnabled()) {
                log.trace("reading property: {}", (Object)f.getProperty());
            }
            return ctx.get(f.getProperty());
        }
        log.warn("illegal args: {}", (Object)Arrays.toString(args));
        throw new HigsonRuntimeException("Illegal arguments passed to PropFunction invocation");
    }

    private PropFunction cast(Function f) {
        if (f instanceof PropFunction) {
            return (PropFunction)f;
        }
        throw new HigsonRuntimeException("Illegal function passed to PropFunctionInvoker: " + f);
    }
}

