/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.matcher;

import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.number.NumberType;
import io.higson.runtime.engine.util.EngineUtil;
import io.higson.runtime.matcher.AbstractMatcher;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSetMatcher
extends AbstractMatcher {
    public static final char DEFAULT_SEPARATOR = ',';
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected char separator = (char)44;

    public AbstractSetMatcher(char separator) {
        this.separator = separator;
    }

    public abstract <T extends ValueHolder> boolean doMatches(String var1, String var2, Type<T> var3);

    @Override
    public <T extends ValueHolder> boolean matches(String value, String pattern, Type<T> type) {
        if (this.isDefaultPattern(pattern)) {
            return true;
        }
        return this.doMatches(value, pattern, type);
    }

    protected String[] split(String text) {
        if (EngineUtil.hasText(text)) {
            return EngineUtil.split(text, this.separator);
        }
        return EMPTY_STRING_ARRAY;
    }

    protected <T extends ValueHolder> String normalize(String text, Type<T> type) {
        if (type instanceof NumberType) {
            return type.convert(type.decode(text).getDouble()).getString();
        }
        return type.encode(type.decode(text.trim()));
    }

    protected <T extends ValueHolder> Set<String> toNormalizedSet(String value, Type<T> type) {
        String[] tokens = this.split(value);
        HashSet<String> set = new HashSet<String>();
        for (String e : tokens) {
            set.add(this.normalize(e, type));
        }
        return set;
    }

    public AbstractSetMatcher() {
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }
}

