/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.prefetch;

import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.dao.FunctionJdbcDao;
import io.higson.runtime.engine.core.function.UnknownFunctionException;
import io.higson.runtime.prefetch.Initializer;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionInitializerImpl
implements Initializer {
    private static final Logger log = LoggerFactory.getLogger(FunctionInitializerImpl.class);
    private static final String CTX_STRING_REPRESENTATION = "ctx";
    private final HigsonEngine engine;
    private final FunctionJdbcDao functionJdbcDao;

    @Override
    public void initialize(String functionCode) {
        try {
            List<String> argumentsListWithoutCtx = this.getArgumentsListWithoutCtx(functionCode);
            this.createProperEngineCall(functionCode, argumentsListWithoutCtx);
        }
        catch (UnknownFunctionException e) {
            log.warn("function not found: {}", (Object)functionCode);
            log.error("failed to initialize", (Throwable)e);
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<String> getArgumentsListWithoutCtx(String functionCode) {
        List<String> argumentsForFunction = this.functionJdbcDao.getArgumentsForFunction(functionCode);
        return argumentsForFunction.stream().filter(argument -> !argument.equals(CTX_STRING_REPRESENTATION)).map(arg -> {
            arg = null;
            return null;
        }).collect(Collectors.toList());
    }

    private void createProperEngineCall(String functionCode, List<String> argumentsListWithoutCtx) {
        if (argumentsListWithoutCtx.isEmpty()) {
            this.engine.call(functionCode, new HigsonContext(new Object[0]), new Object[0]);
        } else {
            this.engine.call(functionCode, new HigsonContext(new Object[0]), argumentsListWithoutCtx);
        }
    }

    public FunctionInitializerImpl(HigsonEngine engine, FunctionJdbcDao functionJdbcDao) {
        this.engine = engine;
        this.functionJdbcDao = functionJdbcDao;
    }
}

