/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.matchers;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.smartparam.engine.matchers.InvalidBetweenMatcherPatternException;
import org.smartparam.engine.matchers.RangeToken;
import org.smartparam.engine.matchers.TokenSeparator;
import org.smartparam.engine.util.EngineUtil;

class NumericTokenSeparator
implements TokenSeparator {
    private final String[] separators;

    @Override
    public RangeToken separate(String pattern) {
        char separator = this.findSeparator(pattern);
        if (this.isHyphenAsSeparator(separator) && StringUtils.countMatches((CharSequence)pattern, (char)separator) > 1) {
            return this.separateByHyphen(pattern, separator);
        }
        return this.separate(pattern, separator);
    }

    private boolean isHyphenAsSeparator(char separator) {
        return separator == "-".charAt(0);
    }

    private boolean containsTwoValues(String[] values) {
        return values.length == 2;
    }

    private String[] extractNumbers(String noWhitespacesPattern) {
        return (String[])Arrays.stream(noWhitespacesPattern.split(this.separatorRegExp())).filter(StringUtils::isNotBlank).toArray(String[]::new);
    }

    private String separatorRegExp() {
        return "[" + String.join((CharSequence)"", this.separators) + "]";
    }

    private RangeToken separate(String pattern, char separator) {
        String[] tokens = EngineUtil.split2(pattern, separator);
        if (tokens.length != 2) {
            throw new InvalidBetweenMatcherPatternException("could not split " + pattern + " pattern to 2 tokens");
        }
        String lower = tokens[0].trim();
        String upper = tokens[1].trim();
        return new RangeToken(lower, upper, separator);
    }

    private char findSeparator(String pattern) {
        return Arrays.stream(this.separators).filter(s -> !"-".equals(s)).filter(pattern::contains).findFirst().orElse("-").charAt(0);
    }

    private RangeToken separateByHyphen(String pattern, char separator) {
        String noWhitespacesPattern = StringUtils.deleteWhitespace((String)pattern);
        String[] values = this.extractNumbers(noWhitespacesPattern);
        if (this.containsTwoValues(values)) {
            String lower = this.prepareLowerValue(noWhitespacesPattern, values[0]);
            String upper = this.prepareUpperValue(noWhitespacesPattern, values[1]);
            return new RangeToken(lower, upper, separator);
        }
        return this.splitOneValuePattern(separator, noWhitespacesPattern, values);
    }

    private RangeToken splitOneValuePattern(char separator, String noWhitespacesPattern, String[] values) {
        if (noWhitespacesPattern.endsWith("-")) {
            return new RangeToken(this.prepareLowerValue(noWhitespacesPattern, values[0]), "", separator);
        }
        return new RangeToken("", this.prepareUpperValue(noWhitespacesPattern, values[0]), separator);
    }

    private String prepareUpperValue(String noWhitespacesPattern, String value) {
        return String.format("%s%s", this.isSecondNumberNegative(noWhitespacesPattern) ? "-" : "", value.trim());
    }

    private String prepareLowerValue(String noWhitespacesPattern, String value) {
        return String.format("%s%s", this.isFirstNumberNegative(noWhitespacesPattern) ? "-" : "", value.trim());
    }

    private boolean isFirstNumberNegative(String noWhitespacesPattern) {
        return noWhitespacesPattern.startsWith("-");
    }

    private boolean isSecondNumberNegative(String noWhitespacesPattern) {
        return noWhitespacesPattern.contains("--");
    }

    public NumericTokenSeparator(String[] separators) {
        this.separators = separators;
    }
}

