/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.date;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public final class DateTimeFormatterPool {
    private static final ThreadLocal<Map<String, DateTimeFormatter>> POOL = ThreadLocal.withInitial(HashMap::new);

    public static DateTimeFormatter ofPattern(String pattern) {
        Map<String, DateTimeFormatter> map = POOL.get();
        return map.computeIfAbsent(pattern, DateTimeFormatter::ofPattern);
    }

    private DateTimeFormatterPool() {
    }
}

