/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.domain;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.core.domain.CacheKey;
import pl.decerto.hyperon.runtime.core.domain.DomainCacheManager;
import pl.decerto.hyperon.runtime.core.domain.MpDomainCacheProvider;
import pl.decerto.hyperon.runtime.core.domain.MpDomainRefreshController;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.TreeDomain;

public abstract class AbstractDomainCacheManager
implements DomainCacheManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractDomainCacheManager.class);
    protected Map<String, TreeDomain> headElementsByProfiles = new ConcurrentHashMap<String, TreeDomain>();
    protected Map<CacheKey, TreeDomain> sessionElementsByCacheKey = new ConcurrentHashMap<CacheKey, TreeDomain>();
    protected final MpDomainRefreshController refreshController;
    protected final MpDomainCacheProvider cacheProvider;

    public AbstractDomainCacheManager(MpDomainCacheProvider cacheProvider, MpDomainRefreshController refreshController) {
        this.cacheProvider = cacheProvider;
        this.refreshController = refreshController;
    }

    protected abstract void refreshHeads(String var1, EffectiveVersionConfiguration var2);

    @Override
    public Set<String> getProfiles() {
        Set<String> head = this.getProfilesFromHead();
        log.trace("getProfiles() found: {}", head);
        return new TreeSet<String>(head);
    }

    Set<String> getProfilesFromHead() {
        return this.headElementsByProfiles.keySet();
    }

    @Override
    public Set<String> getAllProfiles() {
        Set<String> all = this.getHeadAndSessionProfiles();
        log.trace("getAllProfiles() found: {}", all);
        return new TreeSet<String>(all);
    }

    Set<String> getHeadAndSessionProfiles() {
        TreeSet<String> all = new TreeSet<String>();
        for (TreeDomain tree : this.headElementsByProfiles.values()) {
            all.add(tree.getProfile());
        }
        for (TreeDomain tree : this.sessionElementsByCacheKey.values()) {
            all.add(tree.getProfile());
        }
        return all;
    }

    @Override
    public HyperonDomainObject getByPath(String profileCode, String path) {
        return this.getByPath(profileCode, path, null);
    }

    @Override
    public HyperonDomainObject getByPath(String profileCode, String path, EffectiveVersionConfiguration configuration) {
        log.trace("getting element by path, profileCode:{}, path:{}, effective conf:{})", new Object[]{profileCode, path, configuration});
        if (this.headElementsByProfiles.get(profileCode) == null) {
            this.refreshController.updateTimestampsForProfile(profileCode);
            this.refreshHeads(profileCode, configuration);
        }
        if (this.headElementsByProfiles.get(profileCode) == null) {
            return null;
        }
        return this.headElementsByProfiles.get(profileCode).getObjectsByPath(path);
    }

    protected void refreshSessionsOfProfileAndUser(String profileCode, String user, EffectiveVersionConfiguration configuration) {
        log.trace("enter refreshSessionsOfProfileAndUser({},{},{})", new Object[]{profileCode, user, configuration});
        Map<CacheKey, TreeDomain> trees = this.cacheProvider.createTrees(profileCode, user, configuration);
        if (trees.isEmpty()) {
            this.clearSessions(profileCode);
            return;
        }
        for (Map.Entry<CacheKey, TreeDomain> tree : trees.entrySet()) {
            this.saveReloadedTree(tree);
        }
    }

    private void clearSessions(String profileCode) {
        for (Map.Entry<CacheKey, TreeDomain> session : this.sessionElementsByCacheKey.entrySet()) {
            if (!this.containsProfileCode(profileCode, session.getKey())) continue;
            this.sessionElementsByCacheKey.remove(session.getKey());
        }
    }

    public boolean containsProfileCode(String profileCode, CacheKey entryKey) {
        return entryKey.getProfile().endsWith("@" + profileCode);
    }

    private void saveReloadedTree(Map.Entry<CacheKey, TreeDomain> tree) {
        if (tree.getValue().isAnyRoot()) {
            this.sessionElementsByCacheKey.put(tree.getKey(), tree.getValue());
        } else {
            this.sessionElementsByCacheKey.remove(tree.getKey());
        }
    }

    protected void refreshHeads(String profileCode) {
        this.refreshHeads(profileCode, null);
    }

    @Override
    public HyperonDomainObject getSessionElementByPath(String profileCode, String user, String path) {
        return this.getSessionElementByPath(profileCode, user, path, null);
    }

    @Override
    public void invalidateAllCaches() {
        this.headElementsByProfiles.clear();
        this.sessionElementsByCacheKey.clear();
    }
}

