/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.domain;

import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.core.ext.ParamValueProxyFactory;
import pl.decerto.hyperon.runtime.decoder.CascadeDecoder;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.model.HyperonDomainAttribute;
import pl.decerto.hyperon.runtime.model.Type;

public class AttributeValueResolver {
    private final HyperonEngine engine;
    private final CascadeDecoder decoder;

    public AttributeValueResolver(HyperonEngine engine) {
        this.engine = engine;
        this.decoder = new CascadeDecoder(engine);
    }

    public ParamValue getValue(HyperonDomainAttribute attr, ParamContext ctx, Object ... args) {
        Type type = attr.getRawType();
        String text = attr.getRawValue();
        return ParamValueProxyFactory.get(switch (type) {
            case Type.LITERAL -> text;
            case Type.PARAMETER -> this.processParameter(ctx, text);
            case Type.FUNCTION -> this.processFunction(ctx, text, args);
            default -> throw new HyperonRuntimeException("unsupported type: " + type);
        });
    }

    private Object processFunction(ParamContext ctx, String value, Object ... args) {
        if (this.isSimpleFunction(value)) {
            return this.engine.call(value, ctx, args);
        }
        return this.decoder.cascadeCall(value, ctx);
    }

    private Object processParameter(ParamContext ctx, String value) {
        if (this.isSimpleParameter(value)) {
            return this.engine.get(value, ctx);
        }
        return this.decoder.cascadeGetMultiValues(value, ctx);
    }

    private boolean isSimpleParameter(String value) {
        return !value.contains("[");
    }

    private boolean isSimpleFunction(String value) {
        return !value.contains("(") && !value.contains("[");
    }

    public String getDigest(Type type, String value) {
        return this.engine.getDigest(type, value);
    }
}

