/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.function.log;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.event.Level;

public enum FunctionLogLevel {
    OFF(new Level[0]),
    ERROR(Level.ERROR),
    WARN(Level.ERROR, Level.WARN),
    INFO(Level.ERROR, Level.WARN, Level.INFO),
    DEBUG(Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG),
    TRACE(Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE);

    private static final FunctionLogLevel DEFAULT_LOG_LEVEL;
    private final Set<Level> levels;

    private FunctionLogLevel(Level ... levels) {
        this.levels = levels.length > 0 ? Collections.unmodifiableSet(EnumSet.copyOf(Arrays.asList(levels))) : Collections.emptySet();
    }

    public static FunctionLogLevel getDefault() {
        return DEFAULT_LOG_LEVEL;
    }

    public static FunctionLogLevel ofNullable(String rawLogLevel) {
        return rawLogLevel == null ? FunctionLogLevel.getDefault() : FunctionLogLevel.valueOf(rawLogLevel);
    }

    public Set<Level> getLevels() {
        return this.levels;
    }

    static {
        DEFAULT_LOG_LEVEL = INFO;
    }
}

