/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.function.log;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.ParameterValueNotFoundException;
import org.smartparam.engine.core.UnknownParameterException;
import org.smartparam.engine.core.output.GettingWrongTypeException;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.function.log.FunctionLogLevel;
import pl.decerto.hyperon.runtime.function.log.FunctionLogLevelCache;
import pl.decerto.hyperon.runtime.model.Function;

public class FunctionLogLevelResolver {
    private static final Logger log = LoggerFactory.getLogger(FunctionLogLevelResolver.class);
    private static final String SYSTEM_FUNCTION_LOG_LEVEL_PARAMETER_NAME = "system.function.logging.level";
    private static final String SYSTEM_FUNCTION_LOG_LEVEL_PARAMETER_CTX_CODE = "code";
    private final HyperonEngine hyperonEngine;
    private final FunctionLogLevelCache cache;

    public FunctionLogLevelResolver(HyperonEngine hyperonEngine, FunctionLogLevelCache cache) {
        this.hyperonEngine = hyperonEngine;
        this.cache = cache;
    }

    public FunctionLogLevelResolver(HyperonEngine hyperonEngine) {
        this(hyperonEngine, new FunctionLogLevelCache());
    }

    public FunctionLogLevel getFunctionFinalLogLevel(Function function) {
        String code = function.getCode();
        FunctionLogLevel logLevel = this.cache.get(code);
        if (logLevel == null) {
            logLevel = this.getFunctionSystemLogLevel(code).orElse(function.getLogLevel());
            this.cache.put(code, logLevel);
        }
        return logLevel;
    }

    public Optional<FunctionLogLevel> getFunctionSystemLogLevel(String functionCode) {
        HyperonContext ctx = new HyperonContext(new Object[0]).set(SYSTEM_FUNCTION_LOG_LEVEL_PARAMETER_CTX_CODE, functionCode);
        try {
            ParamValue paramValue = this.hyperonEngine.get(SYSTEM_FUNCTION_LOG_LEVEL_PARAMETER_NAME, ctx);
            if (paramValue == null) {
                return Optional.empty();
            }
            return Optional.of(FunctionLogLevel.valueOf(this.getRawFunctionLogLevel(paramValue)));
        }
        catch (IllegalArgumentException | GettingWrongTypeException exc) {
            log.error("Parameter system.function.logging.level contains value that is not an acceptable logging level.");
        }
        catch (ParameterValueNotFoundException | UnknownParameterException | HyperonRuntimeException runtimeException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private String getRawFunctionLogLevel(ParamValue paramValue) {
        return paramValue.getString() != null ? paramValue.getString().toUpperCase() : "";
    }

    public String toString() {
        return "FunctionLogLevelResolver[cache=" + this.cache + "]";
    }
}

