/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.runtime.model.DomainTokenResolver;
import pl.decerto.hyperon.runtime.model.HyperonAttributeDefinition;
import pl.decerto.hyperon.runtime.model.HyperonAttributeDefinitionImpl;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectType;

public class HyperonDomainObjectTypeImpl
implements HyperonDomainObjectType {
    private final Integer id;
    private final String code;
    private final String name;
    private List<HyperonDomainObjectType> parentTypes = new ArrayList<HyperonDomainObjectType>();
    private List<HyperonDomainObjectType> childrenTypes = new ArrayList<HyperonDomainObjectType>();
    private List<HyperonAttributeDefinition> attributeDefinitions = new ArrayList<HyperonAttributeDefinition>();
    private Map<String, HyperonAttributeDefinition> attributeDefinitionMap = new HashMap<String, HyperonAttributeDefinition>();
    private Integer collectionType;
    private Integer typeId;
    private String typeCode;
    private String typeName;
    private boolean multiple;
    private boolean visible;
    private boolean rootCollection;
    private String parentTypeCode;
    private String typeNature;
    private int order;
    private Comparator<HyperonDomainObjectType> comparator = new CollectionComparator();
    private Comparator<HyperonAttributeDefinition> attrComparator = new AttrComparator();

    public HyperonDomainObjectTypeImpl(int id, String code, String name) {
        this.id = id;
        this.code = code;
        this.name = name;
    }

    @Override
    public List<HyperonDomainObjectType> getParentTypes() {
        ArrayList<HyperonDomainObjectType> copy = new ArrayList<HyperonDomainObjectType>(this.parentTypes);
        copy.sort(this.comparator);
        return copy;
    }

    public void addParentTypes(HyperonDomainObjectTypeImpl parentType) {
        this.parentTypes.add(parentType);
    }

    @Override
    public List<HyperonDomainObjectType> getChildrenTypes() {
        ArrayList<HyperonDomainObjectType> copy = new ArrayList<HyperonDomainObjectType>(this.childrenTypes);
        copy.sort(this.comparator);
        return copy;
    }

    public void addChildrenTypes(HyperonDomainObjectTypeImpl childrenType) {
        this.childrenTypes.add(childrenType);
    }

    @Override
    public List<HyperonAttributeDefinition> getAttributeDefinitions() {
        ArrayList<HyperonAttributeDefinition> copy = new ArrayList<HyperonAttributeDefinition>(this.attributeDefinitions);
        copy.sort(this.attrComparator);
        return copy;
    }

    @Override
    public HyperonAttributeDefinition getAttributeDefinition(String code) {
        return this.attributeDefinitionMap.get(code);
    }

    public void addAttributeDefinition(HyperonAttributeDefinition attrDefinition) {
        this.attributeDefinitions.add(attrDefinition);
        this.attributeDefinitionMap.put(attrDefinition.getCode(), attrDefinition);
    }

    public String getFullCode() {
        return DomainTokenResolver.resolveFullToken(this.parentTypeCode, this.code);
    }

    public String toString() {
        return "MppDomainObjectTypeDto [id=" + this.id + ", code=" + this.code + ", name=" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HyperonDomainObjectTypeImpl other = (HyperonDomainObjectTypeImpl)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Integer getId() {
        return this.id;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getCollectionType() {
        return this.collectionType;
    }

    public Integer getTypeId() {
        return this.typeId;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isRootCollection() {
        return this.rootCollection;
    }

    public String getParentTypeCode() {
        return this.parentTypeCode;
    }

    public String getTypeNature() {
        return this.typeNature;
    }

    public int getOrder() {
        return this.order;
    }

    public void setCollectionType(Integer collectionType) {
        this.collectionType = collectionType;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setRootCollection(boolean rootCollection) {
        this.rootCollection = rootCollection;
    }

    public void setParentTypeCode(String parentTypeCode) {
        this.parentTypeCode = parentTypeCode;
    }

    public void setTypeNature(String typeNature) {
        this.typeNature = typeNature;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private final class CollectionComparator
    implements Comparator<HyperonDomainObjectType> {
        private CollectionComparator() {
        }

        @Override
        public int compare(HyperonDomainObjectType o1, HyperonDomainObjectType o2) {
            return Integer.compare(((HyperonDomainObjectTypeImpl)o1).getOrder(), ((HyperonDomainObjectTypeImpl)o2).getOrder());
        }
    }

    final class AttrComparator
    implements Comparator<HyperonAttributeDefinition> {
        AttrComparator() {
        }

        @Override
        public int compare(HyperonAttributeDefinition o1, HyperonAttributeDefinition o2) {
            int groupCompare = StringUtils.trimToEmpty((String)o2.getGroupName()).compareTo(StringUtils.trimToEmpty((String)o1.getGroupName()));
            if (groupCompare == 0) {
                return Integer.compare(((HyperonAttributeDefinitionImpl)o1).getOrder(), ((HyperonAttributeDefinitionImpl)o2).getOrder());
            }
            return groupCompare;
        }
    }
}

