/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.rhino;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;
import org.smartparam.engine.annotated.annotations.FetchSuggestion;
import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.output.ParamValue;
import org.smartparam.engine.core.type.ValueHolder;
import org.smartparam.engine.types.bool.BooleanHolder;
import org.smartparam.engine.types.date.DateHolder;
import org.smartparam.engine.types.date.DateType;
import org.smartparam.engine.types.date.LocalDateType;
import org.smartparam.engine.types.datetime.LocalDateTimeType;
import org.smartparam.engine.types.integer.IntegerHolder;
import org.smartparam.engine.types.integer.IntegerType;
import org.smartparam.engine.types.number.NumberHolder;
import org.smartparam.engine.types.number.NumberType;
import org.smartparam.engine.types.string.StringHolder;
import org.smartparam.engine.types.string.StringType;
import pl.decerto.hyperon.runtime.core.AdhocContext;
import pl.decerto.hyperon.runtime.core.EmptyParamValue;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.helper.TypeConverter;
import pl.decerto.hyperon.runtime.rhino.value.RhinoEmptyValue;
import pl.decerto.hyperon.runtime.rhino.value.RhinoParamValue;
import pl.decerto.hyperon.runtime.type.BooleanType;

public class RhinoHyperon {
    private static final ParamContext EMPTY_CONTEXT = new HyperonContext(new Object[0]);
    private final HyperonEngine service;
    private final TypeConverter type = TypeConverter.getInstance();

    public RhinoHyperon(HyperonEngine service) {
        this.service = service;
    }

    @FetchSuggestion(value="suggester.hyperon.get_str_ctx")
    public Object get(String param, ParamContext ctx) {
        ValueHolder holder = this.getHolder(param, ctx);
        if (holder instanceof NumberHolder) {
            return holder.doubleValue();
        }
        if (holder instanceof IntegerHolder) {
            return holder.longValue();
        }
        return this.unwrap(holder);
    }

    @FetchSuggestion(value="suggester.hyperon.get_str_obj")
    public Object get(String param, Object ... tokens) {
        return this.get(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getString_str_ctx")
    public String getString(String param, ParamContext ctx) {
        ValueHolder holder = this.getHolder(param, ctx);
        return this.toStringHolder(holder).getValue();
    }

    @FetchSuggestion(value="suggester.hyperon.getString_str_obj")
    public String getString(String param, Object ... tokens) {
        return this.getString(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getNumber_str_ctx")
    public double getNumber(String param, ParamContext ctx) {
        ValueHolder holder = this.getHolder(param, ctx);
        return this.toNumberHolder(holder).doubleValue();
    }

    @FetchSuggestion(value="suggester.hyperon.getNumber_str_obj")
    public double getNumber(String param, Object ... tokens) {
        return this.getNumber(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getDecimal_str_ctx")
    public BigDecimal getDecimal(String param, ParamContext ctx) {
        ValueHolder holder = this.getHolder(param, ctx);
        if (holder instanceof NumberHolder || holder instanceof IntegerHolder) {
            return holder.getBigDecimal();
        }
        return this.toNumberHolder(holder).getBigDecimal();
    }

    @FetchSuggestion(value="suggester.hyperon.getDecimal_str_obj")
    public BigDecimal getDecimal(String param, Object ... tokens) {
        return this.getDecimal(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getInteger_str_ctx")
    public Integer getInteger(String param, ParamContext ctx) {
        ValueHolder holder = this.getHolder(param, ctx);
        if (holder instanceof IntegerHolder) {
            return holder.getInteger();
        }
        return this.toNumberHolder(holder).getInteger();
    }

    @FetchSuggestion(value="suggester.hyperon.getInteger_str_obj")
    public Integer getInteger(String param, Object ... tokens) {
        return this.getInteger(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getDate_str_ctx")
    public Date getDate(String param, ParamContext ctx) {
        ValueHolder holder = this.getHolder(param, ctx);
        return this.toDateHolder(holder).getDate();
    }

    @FetchSuggestion(value="suggester.hyperon.getLocalDate_str_ctx")
    public LocalDate getLocalDate(String param, ParamContext ctx) {
        ValueHolder holder = this.getHolder(param, ctx);
        return this.type.toLocalDateHolder(holder).getLocalDate();
    }

    @FetchSuggestion(value="suggester.hyperon.getLocalDateTime_str_ctx")
    public LocalDateTime getLocalDateTime(String param, ParamContext ctx) {
        ValueHolder holder = this.getHolder(param, ctx);
        return this.type.toLocalDateTimeHolder(holder).getLocalDateTime();
    }

    @FetchSuggestion(value="suggester.hyperon.getDate_str_obj")
    public Date getDate(String param, Object ... tokens) {
        return this.getDate(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getLocalDate_str_obj")
    public LocalDate getLocalDate(String param, Object ... tokens) {
        return this.getLocalDate(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getLocalDateTime_str_obj")
    public LocalDateTime getLocalDateTime(String param, Object ... tokens) {
        return this.getLocalDateTime(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getBoolean_str_ctx")
    public boolean getBoolean(String param, ParamContext ctx) {
        ValueHolder holder = this.getHolder(param, ctx);
        return this.toBooleanHolder(holder).booleanValue();
    }

    @FetchSuggestion(value="suggester.hyperon.getBoolean_str_obj")
    public boolean getBoolean(String param, Object ... tokens) {
        return this.getBoolean(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getValue_str_ctx")
    public RhinoParamValue getValue(String param, ParamContext ctx) {
        ParamValue pv = this.value(param, ctx);
        if (pv == null) {
            return null;
        }
        if (pv.getClass() == EmptyParamValue.class) {
            return RhinoEmptyValue.INSTANCE;
        }
        return new RhinoParamValue(pv);
    }

    @FetchSuggestion(value="suggester.hyperon.getValue_str_obj")
    public RhinoParamValue getValue(String param, Object ... tokens) {
        return this.getValue(param, this.createContext(tokens));
    }

    @FetchSuggestion(value="suggester.hyperon.getParamValue_str_ctx")
    public ParamValue getParamValue(String param, ParamContext ctx) {
        return this.value(param, ctx);
    }

    @FetchSuggestion(value="suggester.hyperon.getParamValue_str_obj")
    public ParamValue getParamValue(String param, Object ... tokens) {
        return this.value(param, tokens);
    }

    @FetchSuggestion(value="suggester.hyperon.getValue_str_ctx")
    public ParamValue value(String param, ParamContext ctx) {
        return this.service.get(param, ctx);
    }

    @FetchSuggestion(value="suggester.hyperon.getValue_str_obj")
    public ParamValue value(String param, Object ... tokens) {
        return this.value(param, this.createContext(tokens));
    }

    @Deprecated
    @FetchSuggestion(value="suggester.hyperon.getNum")
    public double getNum(String param, ParamContext ctx) {
        ParamValue pv = this.value(param, ctx);
        if (pv == null) {
            return 0.0;
        }
        ValueHolder holder = pv.getHolder();
        if (holder instanceof NumberHolder) {
            return holder.doubleValue();
        }
        if (holder instanceof IntegerHolder) {
            return holder.longValue();
        }
        return 0.0;
    }

    @FetchSuggestion(value="suggester.hyperon.call_str_ctx_obj")
    public Object call(String functionName, ParamContext ctx, Object ... args) {
        return this.service.call(functionName, ctx, args);
    }

    @FetchSuggestion(value="suggester.hyperon.call_str_ctx")
    public Object call(String functionName, ParamContext ctx) {
        return this.call(functionName, Optional.ofNullable(ctx).orElse(EMPTY_CONTEXT), (Object[])null);
    }

    @FetchSuggestion(value="suggester.hyperon.call_str_obj")
    public Object call(String functionName, Object ... args) {
        return this.service.call(functionName, EMPTY_CONTEXT, args);
    }

    @FetchSuggestion(value="suggester.hyperon.callValue")
    public RhinoParamValue callValue(String functionName, ParamContext ctx, Object ... args) {
        Object value = this.call(functionName, ctx, args);
        if (value instanceof ParamValue) {
            return new RhinoParamValue((ParamValue)value);
        }
        if (value instanceof RhinoParamValue) {
            return (RhinoParamValue)value;
        }
        if (value == null) {
            return null;
        }
        throw new HyperonRuntimeException("Expected ParamValue but function returned class " + this.clazz(value));
    }

    @FetchSuggestion(value="suggester.hyperon.callNumber")
    public double callNumber(String functionName, ParamContext ctx, Object ... args) {
        Object value = this.call(functionName, ctx, args);
        return this.type.getNumber(value);
    }

    @FetchSuggestion(value="suggester.hyperon.callDecimal")
    public BigDecimal callDecimal(String functionName, ParamContext ctx, Object ... args) {
        Object value = this.call(functionName, ctx, args);
        return this.type.getDecimal(value);
    }

    @FetchSuggestion(value="suggester.hyperon.callInteger")
    public Integer callInteger(String functionName, ParamContext ctx, Object ... args) {
        Object value = this.call(functionName, ctx, args);
        return this.type.getInteger(value);
    }

    @FetchSuggestion(value="suggester.hyperon.callDate")
    public Date callDate(String functionName, ParamContext ctx, Object ... args) {
        Object value = this.call(functionName, ctx, args);
        return this.type.getDate(value);
    }

    @FetchSuggestion(value="suggester.hyperon.callLocalDate")
    public LocalDate callLocalDate(String functionName, ParamContext ctx, Object ... args) {
        Object value = this.call(functionName, ctx, args);
        return this.type.getLocalDate(value);
    }

    @FetchSuggestion(value="suggester.hyperon.callLocalDateTime")
    public LocalDateTime callLocalDateTime(String functionName, ParamContext ctx, Object ... args) {
        Object value = this.call(functionName, ctx, args);
        return this.type.getLocalDateTime(value);
    }

    @FetchSuggestion(value="suggester.hyperon.callString")
    public String callString(String functionName, ParamContext ctx, Object ... args) {
        Object value = this.call(functionName, ctx, args);
        return this.type.getString(value);
    }

    @FetchSuggestion(value="suggester.hyperon.callBoolean")
    public boolean callBoolean(String functionName, ParamContext ctx, Object ... args) {
        Object value = this.call(functionName, ctx, args);
        return this.type.getBoolean(value);
    }

    @FetchSuggestion(value="suggester.hyperon.getStringType")
    public StringType getStringType() {
        return this.type.getStringType();
    }

    @FetchSuggestion(value="suggester.hyperon.getNumberType")
    public NumberType getNumberType() {
        return this.type.getNumberType();
    }

    @FetchSuggestion(value="suggester.hyperon.getIntegerType")
    public IntegerType getIntegerType() {
        return this.type.getIntegerType();
    }

    @FetchSuggestion(value="suggester.hyperon.getBooleanType")
    public BooleanType getBooleanType() {
        return this.type.getBooleanType();
    }

    @FetchSuggestion(value="suggester.hyperon.getDateType")
    public DateType getDateType() {
        return this.type.getDateType();
    }

    @FetchSuggestion(value="suggester.hyperon.getLocalDateType")
    public LocalDateType getLocalDateType() {
        return this.type.getLocalDateType();
    }

    @FetchSuggestion(value="suggester.hyperon.getLocalDateTimeType")
    public LocalDateTimeType getLocalDateTimeType() {
        return this.type.getLocalDateTimeType();
    }

    ValueHolder getHolder(String param, ParamContext ctx) {
        ParamValue value = this.value(param, ctx);
        return value != null && value.size() > 0 ? value.getHolder() : null;
    }

    private DateHolder toDateHolder(ValueHolder holder) {
        return this.type.toDateHolder(holder);
    }

    private NumberHolder toNumberHolder(ValueHolder holder) {
        return this.type.toNumberHolder(holder);
    }

    private BooleanHolder toBooleanHolder(ValueHolder holder) {
        return this.type.toBooleanHolder(holder);
    }

    private StringHolder toStringHolder(ValueHolder holder) {
        return this.type.toStringHolder(holder);
    }

    private Object unwrap(ValueHolder holder) {
        return holder != null ? holder.getValue() : null;
    }

    @FetchSuggestion(value="suggester.hyperon.createContext")
    public HyperonContext createContext(Object ... args) {
        return new AdhocContext(args);
    }

    private String clazz(Object obj) {
        return obj != null ? obj.getClass().getName() : null;
    }
}

