/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.domain;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import pl.decerto.hyperon.common.persistence.jpa.BaseEntity;
import pl.decerto.hyperon.common.security.domain.SystemRightJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;

@Entity
public class SystemRoleJPA
extends BaseEntity {
    public static final int MAX_NAME_LENGTH = 100;
    @Id
    @SequenceGenerator(name="systemrolejpa_id_generator", sequenceName="SEQ_SYSTEM_ROLE_JPA")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="systemrolejpa_id_generator")
    private int id;
    @Column(length=100, nullable=false, unique=true)
    @NotEmpty
    private String code;
    @Column
    private String description;
    @NotNull
    private Date createDate;
    @ManyToMany(mappedBy="roles", fetch=FetchType.EAGER)
    private Set<SystemUserJPA> users = new HashSet<SystemUserJPA>();
    @ManyToMany(fetch=FetchType.EAGER)
    private Set<SystemRightJPA> rights = new HashSet<SystemRightJPA>();

    public static Iterable<String> getRolesCodes(Iterable<SystemRoleJPA> roles) {
        return StreamSupport.stream(roles.spliterator(), false).map(SystemRoleJPA::getCode).collect(Collectors.toList());
    }

    @PrePersist
    public void create() {
        this.createDate = new Date();
    }

    public void addUser(SystemUserJPA userModel) {
        this.users.add(userModel);
    }

    public void addRight(SystemRightJPA systemRightJPA) {
        this.rights.add(systemRightJPA);
    }

    public String toString() {
        return "SystemRoleJPA [ id=" + this.id + ", code=" + this.code + ", description=" + this.description + ", createDate=" + this.createDate + ", users=" + this.users + "]";
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreateDate(@NotNull Date createDate) {
        this.createDate = createDate;
    }

    public void setUsers(Set<SystemUserJPA> users) {
        this.users = users;
    }

    public void setRights(Set<SystemRightJPA> rights) {
        this.rights = rights;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public Date getCreateDate() {
        return this.createDate;
    }

    public Set<SystemUserJPA> getUsers() {
        return this.users;
    }

    public Set<SystemRightJPA> getRights() {
        return this.rights;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemRoleJPA)) {
            return false;
        }
        SystemRoleJPA other = (SystemRoleJPA)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        Set<SystemUserJPA> this$users = this.getUsers();
        Set<SystemUserJPA> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        Set<SystemRightJPA> this$rights = this.getRights();
        Set<SystemRightJPA> other$rights = other.getRights();
        return !(this$rights == null ? other$rights != null : !((Object)this$rights).equals(other$rights));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemRoleJPA;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        Set<SystemUserJPA> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        Set<SystemRightJPA> $rights = this.getRights();
        result = result * 59 + ($rights == null ? 43 : ((Object)$rights).hashCode());
        return result;
    }
}

