/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.jwt;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.domain.JwtToken;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.domain.TokenType;
import pl.decerto.hyperon.common.security.jwt.JwtSecretKeyNotSpecifiedException;
import pl.decerto.hyperon.common.utils.Messages;

@Component
public class JwtTokenGenerator {
    private final String secretKey;

    public JwtTokenGenerator(@Value(value="${higson.security.jwt.secret-key:#{null}}") String secretKey) {
        this.secretKey = secretKey;
    }

    public JwtToken generateJwtToken(SystemUserJPA user, LocalDateTime expirationDate) {
        if (StringUtils.isBlank((CharSequence)this.secretKey)) {
            throw new JwtSecretKeyNotSpecifiedException(Messages.message("jwt.secret.notSpecified"));
        }
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        byte[] apiKeySecretBytes = this.secretKey.getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setIssuedAt((Date)Timestamp.valueOf(LocalDateTime.now())).setExpiration((Date)Timestamp.valueOf(expirationDate)).claim("userLogin", (Object)user.getLogin()).claim("firstName", (Object)user.getFirstName()).claim("lastName", (Object)user.getLastName()).claim("email", (Object)user.getEmail()).signWith((Key)signingKey, signatureAlgorithm);
        String jwtToken = builder.compact();
        return this.getJwtTokenEntity(jwtToken, user, expirationDate);
    }

    private JwtToken getJwtTokenEntity(String jwtToken, SystemUserJPA user, LocalDateTime expirationDate) {
        JwtToken jwtTokenEntity = new JwtToken();
        jwtTokenEntity.setCreateDate(LocalDateTime.now());
        jwtTokenEntity.setExpirationDate(expirationDate);
        jwtTokenEntity.setToken(jwtToken);
        jwtTokenEntity.setUser(user);
        jwtTokenEntity.setTokenType(TokenType.RUNTIME_REST_TOKEN);
        return jwtTokenEntity;
    }
}

