/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.jwt;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.decerto.hyperon.common.security.dao.JwtTokenDao;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;
import pl.decerto.hyperon.common.security.domain.JwtToken;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.domain.TokenType;
import pl.decerto.hyperon.common.security.dto.JwtTokenDto;
import pl.decerto.hyperon.common.security.jwt.JwtTokenGenerator;
import pl.decerto.hyperon.common.security.jwt.JwtTokenService;
import pl.decerto.hyperon.common.security.mapper.JwtTokenMapper;
import pl.decerto.hyperon.common.utils.LoginHelper;

@Service
public class JwtTokenServiceImpl
implements JwtTokenService {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenServiceImpl.class);
    private final JwtTokenDao jwtTokenDao;
    private final JwtTokenMapper jwtTokenMapper;
    private final UserManagementDao userManagementDao;
    private final JwtTokenGenerator jwtTokenGenerator;

    @Override
    @Transactional
    public JwtToken createJwtTokenForCurrentUser(LocalDateTime expirationDate) {
        String currentUserName = LoginHelper.getCurrentUserName();
        return this.generateJwtToken(expirationDate, currentUserName);
    }

    @Override
    @Transactional
    public JwtToken createJwtToken(LocalDateTime expirationDate, String userLogin) {
        return this.generateJwtToken(expirationDate, userLogin);
    }

    private JwtToken generateJwtToken(LocalDateTime expirationDate, String currentUserName) {
        log.debug("start generating JWT token for user: {}", (Object)currentUserName);
        SystemUserJPA currentUser = this.userManagementDao.findByLogin(currentUserName);
        JwtToken jwtToken = this.jwtTokenGenerator.generateJwtToken(currentUser, expirationDate);
        jwtToken = (JwtToken)this.jwtTokenDao.save(jwtToken);
        log.debug("end generating JWT token");
        return jwtToken;
    }

    @Override
    @Transactional
    public List<JwtTokenDto> getJwtTokensForCurrentUser() {
        String currentUserName = LoginHelper.getCurrentUserName();
        SystemUserJPA currentUser = this.userManagementDao.findByLogin(currentUserName);
        List<JwtToken> tokensByUser = this.jwtTokenDao.findRuntimeRestTokens(currentUser.getId());
        return tokensByUser.stream().map(this.jwtTokenMapper::toDto).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly=true)
    public List<JwtTokenDto> getAllJwtTokens() {
        return this.jwtTokenDao.findByTokenType(TokenType.RUNTIME_REST_TOKEN).stream().map(this.jwtTokenMapper::toDto).toList();
    }

    @Override
    @Transactional
    public void removeJwtToken(int id) {
        log.debug("Removing JWT token with id: {}", (Object)id);
        this.jwtTokenDao.deleteById(id);
        log.debug("JWT token removed");
    }

    @Override
    @Transactional
    public void removeJwtTokens(List<Integer> jwtTokenIds) {
        log.debug("Removing JWT tokens");
        jwtTokenIds.forEach(arg_0 -> ((JwtTokenDao)this.jwtTokenDao).deleteById(arg_0));
        log.debug("JWT tokens removed");
    }

    @Override
    public boolean wasJwtTokenGeneratedForUser(int userId) {
        return CollectionUtils.isNotEmpty(this.jwtTokenDao.findRuntimeRestTokens(userId));
    }

    @Override
    @Transactional
    public void removeJwtTokenByTokens(List<String> tokens, TokenType tokenType) {
        this.jwtTokenDao.deleteJwtTokensByTokenInAndTokenType(tokens, tokenType);
    }

    public JwtTokenServiceImpl(JwtTokenDao jwtTokenDao, JwtTokenMapper jwtTokenMapper, UserManagementDao userManagementDao, JwtTokenGenerator jwtTokenGenerator) {
        this.jwtTokenDao = jwtTokenDao;
        this.jwtTokenMapper = jwtTokenMapper;
        this.userManagementDao = userManagementDao;
        this.jwtTokenGenerator = jwtTokenGenerator;
    }
}

