/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.oauth2;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.AbstractAuthorizationManager;
import pl.decerto.hyperon.common.security.AccessGateway;
import pl.decerto.hyperon.common.security.MppUserDetails;
import pl.decerto.hyperon.common.security.oauth2.HyperonOidcUserDetails;
import pl.decerto.hyperon.common.security.oauth2.OAuth2PropertyCondition;

@Component
@OAuth2PropertyCondition
public class OAuth2AuthorizationManager
extends AbstractAuthorizationManager {
    private static final Logger log = LoggerFactory.getLogger(OAuth2AuthorizationManager.class);
    private static final String SCOPE = "scope";
    private final AccessGateway accessGateway;
    private final JwtClaimValidator<List<String>> audienceValidator;
    private final JwtTimestampValidator jwtTimestampValidator;

    @Override
    protected boolean tryAuthorize(Authentication authentication) {
        HyperonOidcUserDetails oidcUser = (HyperonOidcUserDetails)((Object)authentication.getPrincipal());
        MppUserDetails principal = oidcUser.getHyperonUserDetails();
        boolean isSuccess = this.isUserAuthorized(principal);
        boolean allMatch = this.validateRequiredTokenFields(oidcUser);
        boolean isAuthorized = allMatch && isSuccess;
        log.trace("Authorization, isSuccess={}.", (Object)isAuthorized);
        return isAuthorized;
    }

    private boolean isUserAuthorized(MppUserDetails principal) {
        return this.accessGateway.authorizeUser(principal, principal.getUsername()).isSuccess();
    }

    private boolean validateRequiredTokenFields(HyperonOidcUserDetails oidcUser) {
        OidcIdToken token = oidcUser.getIdToken();
        Jwt jwt = this.getJwt(oidcUser, token);
        boolean audienceMatch = this.isValidationSucceed((OAuth2TokenValidator)this.audienceValidator, jwt);
        boolean timestampMatch = this.isValidationSucceed(this.jwtTimestampValidator, jwt);
        return audienceMatch && timestampMatch;
    }

    private <T extends OAuth2TokenValidator<Jwt>> boolean isValidationSucceed(T validator, Jwt jwt) {
        return !validator.validate((AbstractOAuth2Token)jwt).hasErrors();
    }

    private Jwt getJwt(HyperonOidcUserDetails oidcUser, OidcIdToken token) {
        HashMap claims = new HashMap(token.getClaims());
        if (!token.getClaims().containsKey(SCOPE)) {
            claims.put(SCOPE, oidcUser.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toUnmodifiableList()));
        }
        return Jwt.withTokenValue((String)token.getTokenValue()).issuer(token.getIssuer().toString()).issuedAt(token.getIssuedAt()).expiresAt(token.getExpiresAt()).claims(it -> it.putAll(claims)).headers(it -> it.putAll(claims)).build();
    }

    @Override
    protected boolean authenticationObjectTypeMatches(Authentication authentication) {
        return authentication instanceof OAuth2AuthenticationToken;
    }

    public OAuth2AuthorizationManager(AccessGateway accessGateway, JwtClaimValidator<List<String>> audienceValidator, JwtTimestampValidator jwtTimestampValidator) {
        this.accessGateway = accessGateway;
        this.audienceValidator = audienceValidator;
        this.jwtTimestampValidator = jwtTimestampValidator;
    }
}

