/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.runtime.dgmimpl.arrays.IntegerArrayGetAtMetaMethod;
import org.codehaus.groovy.syntax.Token;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.lang.Wildcard;
import org.spockframework.util.ObjectUtil;
import spock.lang.Specification;

public abstract class AstUtil {
    private static final Pattern DATA_TABLE_SEPARATOR = Pattern.compile("_{2,}+");
    private static final String GET_METHOD_NAME = "get";
    private static final String GET_AT_METHOD_NAME = new IntegerArrayGetAtMetaMethod().getName();

    public static boolean hasAnnotation(ASTNode node, Class<?> annotationType) {
        return AstUtil.getAnnotation(node, annotationType) != null;
    }

    public static AnnotationNode getAnnotation(ASTNode node, Class<?> annotationType) {
        if (!(node instanceof AnnotatedNode)) {
            return null;
        }
        AnnotatedNode annotated = (AnnotatedNode)node;
        List annotations = annotated.getAnnotations();
        for (AnnotationNode a : annotations) {
            if (!a.getClassNode().getName().equals(annotationType.getName())) continue;
            return a;
        }
        return null;
    }

    public static List<Statement> getStatements(MethodNode method) {
        Statement code = method.getCode();
        if (!(code instanceof BlockStatement)) {
            BlockStatement block = new BlockStatement();
            if (code != null) {
                block.addStatement(code);
            }
            method.setCode((Statement)block);
        }
        return ((BlockStatement)method.getCode()).getStatements();
    }

    public static List<Statement> getStatements(ClosureExpression closure) {
        BlockStatement blockStat = (BlockStatement)closure.getCode();
        return blockStat == null ? Collections.emptyList() : blockStat.getStatements();
    }

    public static boolean isInvocationWithImplicitThis(Expression invocation) {
        if (invocation instanceof PropertyExpression) {
            return ((PropertyExpression)invocation).isImplicitThis();
        }
        if (invocation instanceof MethodCallExpression) {
            return ((MethodCallExpression)invocation).isImplicitThis();
        }
        return false;
    }

    public static boolean hasImplicitParameter(ClosureExpression expr) {
        return expr.getParameters() != null && expr.getParameters().length == 0;
    }

    public static Expression getImplicitParameterRef(ClosureExpression expr) {
        assert (AstUtil.hasImplicitParameter(expr));
        DynamicVariable var = new DynamicVariable("it", false);
        return new VariableExpression((Variable)var);
    }

    public static Expression getInvocationTarget(Expression expr) {
        if (expr instanceof PropertyExpression) {
            return ((PropertyExpression)expr).getObjectExpression();
        }
        if (expr instanceof MethodCallExpression) {
            return ((MethodCallExpression)expr).getObjectExpression();
        }
        if (expr instanceof StaticMethodCallExpression) {
            return new ClassExpression(((StaticMethodCallExpression)expr).getOwnerType());
        }
        if (expr instanceof ConstructorCallExpression) {
            return new ClassExpression(expr.getType());
        }
        return null;
    }

    public static boolean isWildcardRef(Expression expr) {
        VariableExpression varExpr = ObjectUtil.asInstance(expr, VariableExpression.class);
        if (varExpr == null || !varExpr.getName().equals(Wildcard.INSTANCE.toString())) {
            return false;
        }
        Variable accessedVar = varExpr.getAccessedVariable();
        if (!(accessedVar instanceof FieldNode)) {
            return false;
        }
        return ((FieldNode)accessedVar).getOwner().getName().equals(Specification.class.getName());
    }

    public static boolean isDataTableSeparator(Statement stat) {
        VariableExpression varExpr = AstUtil.getExpression(stat, VariableExpression.class);
        if (varExpr == null || !DATA_TABLE_SEPARATOR.matcher(varExpr.getName()).matches()) {
            return false;
        }
        Variable accessedVar = varExpr.getAccessedVariable();
        return accessedVar instanceof DynamicVariable;
    }

    public static boolean isJavaIdentifier(String id) {
        if (id == null || id.length() == 0 || !Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends Expression> T getExpression(Statement stat, Class<T> type) {
        ExpressionStatement exprStat = ObjectUtil.asInstance(stat, ExpressionStatement.class);
        if (exprStat == null) {
            return null;
        }
        return (T)((Expression)ObjectUtil.asInstance(exprStat.getExpression(), type));
    }

    public static boolean isSynthetic(MethodNode method) {
        return method.isSynthetic() || (method.getModifiers() & 0x1000) != 0;
    }

    public static boolean hasPlausibleSourcePosition(ASTNode node) {
        return node.getLineNumber() > 0 && node.getLastLineNumber() >= node.getLineNumber() && node.getColumnNumber() > 0 && node.getLastColumnNumber() > node.getColumnNumber();
    }

    public static String getMethodName(Expression invocation) {
        if (invocation instanceof MethodCallExpression) {
            return ((MethodCallExpression)invocation).getMethodAsString();
        }
        if (invocation instanceof StaticMethodCallExpression) {
            return ((StaticMethodCallExpression)invocation).getMethod();
        }
        return null;
    }

    public static Expression getArguments(Expression invocation) {
        if (invocation instanceof MethodCallExpression) {
            return ((MethodCallExpression)invocation).getArguments();
        }
        if (invocation instanceof StaticMethodCallExpression) {
            return ((StaticMethodCallExpression)invocation).getArguments();
        }
        if (invocation instanceof ConstructorCallExpression) {
            return ((ConstructorCallExpression)invocation).getArguments();
        }
        return null;
    }

    public static List<Expression> getArgumentList(Expression invocation) {
        return AstUtil.asArgumentList(AstUtil.getArguments(invocation));
    }

    private static List<Expression> asArgumentList(Expression arguments) {
        if (arguments instanceof NamedArgumentListExpression) {
            return Collections.singletonList(arguments);
        }
        return ((TupleExpression)arguments).getExpressions();
    }

    public static Expression toArgumentArray(List<Expression> argList, IRewriteResources resources) {
        ArrayList<Expression> normalArgs = new ArrayList<Expression>();
        ArrayList<Expression> spreadArgs = new ArrayList<Expression>();
        ArrayList<ConstantExpression> spreadPositions = new ArrayList<ConstantExpression>();
        for (int i = 0; i < argList.size(); ++i) {
            Expression arg = argList.get(i);
            if (arg instanceof SpreadExpression) {
                spreadArgs.add(((SpreadExpression)arg).getExpression());
                spreadPositions.add(new ConstantExpression((Object)i));
                continue;
            }
            normalArgs.add(arg);
        }
        if (spreadArgs.isEmpty()) {
            return new ArrayExpression(ClassHelper.OBJECT_TYPE, argList);
        }
        AstNodeCache astNodeCache = resources.getAstNodeCache();
        return AstUtil.createDirectMethodCall((Expression)new ClassExpression(astNodeCache.SpockRuntime), astNodeCache.SpockRuntime_DespreadList, (Expression)new ArgumentListExpression((Expression)new ArrayExpression(ClassHelper.OBJECT_TYPE, normalArgs), (Expression)new ArrayExpression(ClassHelper.OBJECT_TYPE, spreadArgs), (Expression)new ArrayExpression(ClassHelper.int_TYPE, spreadPositions)));
    }

    public static void copySourcePosition(ASTNode from, ASTNode to) {
        to.setLineNumber(from.getLineNumber());
        to.setLastLineNumber(from.getLastLineNumber());
        to.setColumnNumber(from.getColumnNumber());
        to.setLastColumnNumber(from.getLastColumnNumber());
    }

    public static Expression getAssertionMessage(AssertStatement stat) {
        Expression msg = stat.getMessageExpression();
        if (msg == null) {
            return null;
        }
        if (!(msg instanceof ConstantExpression)) {
            return msg;
        }
        return ((ConstantExpression)msg).isNullExpression() ? null : msg;
    }

    public static boolean isThisExpression(Expression expr) {
        return expr instanceof VariableExpression && ((VariableExpression)expr).isThisExpression();
    }

    public static boolean isSuperExpression(Expression expr) {
        return expr instanceof VariableExpression && ((VariableExpression)expr).isSuperExpression();
    }

    public static boolean isThisOrSuperExpression(Expression expr) {
        return AstUtil.isThisExpression(expr) || AstUtil.isSuperExpression(expr);
    }

    public static void setVisibility(MethodNode method, int visibility) {
        int modifiers = method.getModifiers();
        method.setModifiers((modifiers &= 0xFFFFFFF8) | visibility);
    }

    public static int getVisibility(FieldNode field) {
        return field.getModifiers() & 7;
    }

    public static void setVisibility(FieldNode field, int visibility) {
        int modifiers = field.getModifiers();
        field.setModifiers((modifiers &= 0xFFFFFFF8) | visibility);
    }

    public static void setFinal(FieldNode field, boolean isFinal) {
        int modifiers = field.getModifiers();
        modifiers = isFinal ? (modifiers |= 0x10) : (modifiers &= 0xFFFFFFEF);
        field.setModifiers(modifiers);
    }

    public static boolean isJointCompiled(ClassNode clazz) {
        return clazz.getModule().getUnit().getConfig().getJointCompilationOptions() != null;
    }

    public static MethodCallExpression createMethodCall(Expression target, String methodName, Expression arguments) {
        MethodCallExpression result = new MethodCallExpression(target, methodName, arguments);
        result.setImplicitThis(false);
        return result;
    }

    public static MethodCallExpression createDirectMethodCall(Expression target, MethodNode method, Expression arguments) {
        MethodCallExpression result = AstUtil.createMethodCall(target, method.getName(), arguments);
        result.setMethodTarget(method);
        return result;
    }

    public static void deleteMethod(ClassNode clazz, MethodNode method) {
        clazz.getMethods().remove(method);
        clazz.getDeclaredMethods(method.getName()).remove(method);
    }

    public static Expression getVariableName(BinaryExpression assignment) {
        Expression left = assignment.getLeftExpression();
        if (left instanceof Variable) {
            return new ConstantExpression((Object)((Variable)left).getName());
        }
        if (left instanceof FieldExpression) {
            return new ConstantExpression((Object)((FieldExpression)left).getFieldName());
        }
        return ConstantExpression.NULL;
    }

    public static Expression getVariableType(BinaryExpression assignment) {
        ClassNode type = assignment.getLeftExpression().getType();
        return type == null || AstUtil.isDynamicTypedExpression(assignment.getLeftExpression()) ? ConstantExpression.NULL : new ClassExpression(type);
    }

    private static boolean isDynamicTypedExpression(Expression leftExpression) {
        if (leftExpression instanceof VariableExpression) {
            return ((VariableExpression)leftExpression).isDynamicTyped();
        }
        if (leftExpression instanceof FieldExpression) {
            return ((FieldExpression)leftExpression).isDynamicTyped();
        }
        if (leftExpression instanceof PropertyExpression) {
            return ((PropertyExpression)leftExpression).isDynamic();
        }
        return false;
    }

    public static MethodCallExpression createGetAtMethodCall(Expression expression, int index) {
        return AstUtil.createMethodCall(expression, GET_AT_METHOD_NAME, (Expression)new ConstantExpression((Object)index));
    }

    public static MethodCallExpression createGetAtMethodCall(Expression expression, String key) {
        return AstUtil.createMethodCall(expression, GET_AT_METHOD_NAME, (Expression)new ConstantExpression((Object)key));
    }

    public static Expression createGetAtWithMapSupportMethodCall(Expression expression, int index, String key) {
        return new TernaryExpression(new BooleanExpression((Expression)new BinaryExpression(expression, Token.newKeyword((String)"instanceof", (int)-1, (int)-1), (Expression)new ClassExpression(ClassHelper.MAP_TYPE))), (Expression)AstUtil.createMethodCall(expression, GET_AT_METHOD_NAME, (Expression)new ConstantExpression((Object)key)), (Expression)AstUtil.createMethodCall(expression, GET_AT_METHOD_NAME, (Expression)new ConstantExpression((Object)index)));
    }
}

