/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.ReflectionUtil;

public class DefaultMethodInvoker
implements IResponseGenerator {
    private static final Method INVOKE_DEFAULT = ReflectionUtil.getDeclaredMethodByName(InvocationHandler.class, "invokeDefault");
    private final Object target;
    private final Method method;
    private final Object[] arguments;

    public DefaultMethodInvoker(Object target, Method method, Object[] arguments) {
        this.target = target;
        this.method = method;
        this.arguments = arguments;
    }

    @Override
    public Object respond(IMockInvocation invocation) {
        if (INVOKE_DEFAULT == null) {
            return this.useInternalMethodHandle();
        }
        Object[] args = new Object[]{this.target, this.method, this.arguments};
        return ReflectionUtil.invokeMethod(null, INVOKE_DEFAULT, args);
    }

    private Object useInternalMethodHandle() {
        MethodHandle methodHandle;
        try {
            Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            field.setAccessible(true);
            MethodHandles.Lookup implLookup = (MethodHandles.Lookup)field.get(null);
            methodHandle = implLookup.unreflectSpecial(this.method, this.method.getDeclaringClass()).bindTo(this.target);
        }
        catch (Exception e) {
            throw new CannotCreateMockException(this.target.getClass(), "Failed to invoke default method '" + this.method.getName() + "'. Adding '--add-opens=java.base/java.lang.invoke=ALL-UNNAMED' might fix this.", e);
        }
        try {
            return methodHandle.invokeWithArguments(this.arguments);
        }
        catch (Throwable e) {
            return ExceptionUtil.sneakyThrow(e);
        }
    }
}

