/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.List;
import org.objenesis.ObjenesisHelper;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.util.ReflectionUtil;

public class MockInstantiator {
    private static final boolean objenesisAvailable = ReflectionUtil.isClassAvailable("org.objenesis.Objenesis");

    public static Object instantiate(Class<?> declaredType, Class<?> actualType, List<Object> constructorArgs, boolean useObjenesis) {
        try {
            if (!declaredType.isInterface() && constructorArgs == null && useObjenesis && objenesisAvailable) {
                return ObjenesisInstantiator.instantiate(actualType);
            }
            return GroovyRuntimeUtil.invokeConstructor(actualType, constructorArgs == null ? null : constructorArgs.toArray());
        }
        catch (Exception e) {
            String msg = constructorArgs == null && useObjenesis && !objenesisAvailable ? ". To solve this problem, put an up-to-date version of Objenesis on the class path (recommended), or supply constructor arguments (e.g. 'constructorArgs: [42]') that allow to construct an object of the mocked type." : "";
            throw new CannotCreateMockException(declaredType, msg, e);
        }
    }

    private static class ObjenesisInstantiator {
        private ObjenesisInstantiator() {
        }

        static Object instantiate(Class<?> clazz) {
            return clazz.cast(ObjenesisHelper.newInstance(clazz));
        }
    }
}

